/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.skill.cast.handler;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import java.util.Objects;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.event.PlayerKeyPressEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.binding.BoundSkillInfo;
import net.Indyuce.mmocore.skill.cast.PlayerKey;
import net.Indyuce.mmocore.skill.cast.SkillCastingHandler;
import net.Indyuce.mmocore.skill.cast.SkillCastingInstance;
import net.Indyuce.mmocore.skill.cast.SkillCastingMode;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillBar
extends SkillCastingHandler {
    private final PlayerKey mainKey;
    private final boolean disableSneak;
    private final boolean lowestKeybinds;

    public SkillBar(@NotNull ConfigurationSection config) {
        super(config);
        this.mainKey = PlayerKey.valueOf(UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("open"), "Could not find open key")));
        this.disableSneak = config.getBoolean("disable-sneak");
        this.lowestKeybinds = config.getBoolean("use-lowest-keybinds");
    }

    @Override
    public SkillCastingInstance newInstance(@NotNull PlayerData player) {
        return new CustomSkillCastingInstance(player);
    }

    @Override
    public SkillCastingMode getCastingMode() {
        return SkillCastingMode.SKILL_BAR;
    }

    @Override
    public void onSkillBound(@NotNull PlayerData player) {
        if (this.lowestKeybinds) {
            int slot2 = 1;
            for (BoundSkillInfo bound2 : player.getBoundSkills().values()) {
                if (bound2.isPassive()) continue;
                bound2.skillBarCastSlot = slot2++;
            }
        } else {
            player.getBoundSkills().forEach((slot, bound) -> {
                bound.skillBarCastSlot = slot;
            });
        }
    }

    @EventHandler
    public void enterSkillCasting(PlayerKeyPressEvent event) {
        if (event.getPressed() != this.mainKey) {
            return;
        }
        Player player = event.getPlayer();
        if (this.disableSneak && player.isSneaking()) {
            return;
        }
        if (event.getPressed().shouldCancelEvent()) {
            event.setCancelled(true);
        }
        PlayerData playerData = event.getData();
        if (player.getGameMode() != GameMode.SPECTATOR && (MMOCore.plugin.configManager.canCreativeCast || player.getGameMode() != GameMode.CREATIVE) && !playerData.isCasting() && playerData.hasActiveSkillBound() && playerData.setSkillCasting()) {
            MMOCore.plugin.soundManager.getSound(SoundEvent.SPELL_CAST_BEGIN).playTo(player);
        }
    }

    public class CustomSkillCastingInstance
    extends SkillCastingInstance {
        private final String ready;
        private final String onCooldown;
        private final String noMana;
        private final String noStamina;
        private final String split;
        private int j;

        CustomSkillCastingInstance(PlayerData playerData) {
            super(SkillBar.this, playerData);
            this.ready = ConfigMessage.fromKey("casting.action-bar.ready", new Object[0]).asLine();
            this.onCooldown = ConfigMessage.fromKey("casting.action-bar.on-cooldown", new Object[0]).asLine();
            this.noMana = ConfigMessage.fromKey("casting.action-bar.no-mana", new Object[0]).asLine();
            this.noStamina = ConfigMessage.fromKey("casting.action-bar.no-stamina", new Object[0]).asLine();
            this.split = ConfigMessage.fromKey("casting.split", new Object[0]).asLine();
        }

        @EventHandler
        public void onItemHeld(PlayerItemHeldEvent event) {
            if (!event.getPlayer().equals((Object)this.getCaster().getPlayer())) {
                return;
            }
            Player player = event.getPlayer();
            if (SkillBar.this.disableSneak && player.isSneaking()) {
                return;
            }
            if (event.getPreviousSlot() == event.getNewSlot()) {
                return;
            }
            event.setCancelled(true);
            this.refreshTimeOut();
            ClassSkill classSkill = this.findSkillToCast(player.getInventory().getHeldItemSlot(), event.getNewSlot());
            if (classSkill != null) {
                classSkill.toCastable(this.getCaster()).cast(this.getCaster().getMMOPlayerData());
            }
        }

        @Nullable
        private ClassSkill findSkillToCast(int currentSlot, int clickedSlot) {
            for (BoundSkillInfo info : this.getActiveSkills()) {
                if (info.skillBarCastSlot + (currentSlot < info.skillBarCastSlot ? 1 : 0) != 1 + clickedSlot) continue;
                return info.getClassSkill();
            }
            return null;
        }

        @EventHandler
        public void stopCasting(PlayerKeyPressEvent event) {
            if (!event.getPlayer().equals((Object)this.getCaster().getPlayer())) {
                return;
            }
            if (event.getPressed() != SkillBar.this.mainKey) {
                return;
            }
            Player player = event.getPlayer();
            if (SkillBar.this.disableSneak && player.isSneaking()) {
                return;
            }
            if (this.getCaster().leaveSkillCasting()) {
                MMOCore.plugin.soundManager.getSound(SoundEvent.SPELL_CAST_END).playTo(player);
                ConfigMessage.fromKey("casting.no-longer", new Object[0]).send(this.getCaster().getPlayer());
            }
        }

        @NotNull
        private String getFormat(PlayerData data) {
            if (!data.isOnline()) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (BoundSkillInfo active : this.getActiveSkills()) {
                ClassSkill skill = active.getClassSkill();
                int slot = active.skillBarCastSlot;
                str.append(str.isEmpty() ? "" : this.split).append((this.onCooldown(data, skill) ? this.onCooldown.replace("{cooldown}", String.valueOf(data.getCooldownMap().getInfo((CooldownObject)skill).getRemaining() / 1000L)) : (this.noMana(data, skill) ? this.noMana : (this.noStamina(data, skill) ? this.noStamina : this.ready))).replace("{index}", String.valueOf(slot + (data.getPlayer().getInventory().getHeldItemSlot() < slot ? 1 : 0))).replace("{skill}", skill.getSkill().getName()));
            }
            return MMOCore.plugin.placeholderParser.parse((OfflinePlayer)data.getPlayer(), str.toString());
        }

        private boolean onCooldown(PlayerData data, ClassSkill skill) {
            return data.getCooldownMap().isOnCooldown((CooldownObject)skill);
        }

        private boolean noMana(PlayerData data, ClassSkill skill) {
            return skill.getSkill().hasParameter("mana") && skill.getParameter("mana", data.getSkillLevel(skill.getSkill())) > data.getMana();
        }

        private boolean noStamina(PlayerData data, ClassSkill skill) {
            return skill.getSkill().hasParameter("stamina") && skill.getParameter("stamina", data.getSkillLevel(skill.getSkill())) > data.getStamina();
        }

        @Override
        public void onTick() {
            if (this.j++ % 2 == 0) {
                this.getCaster().displayActionBar(this.getFormat(this.getCaster()));
            }
        }
    }
}

