/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.party.compat;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.party.AbstractParty;
import net.Indyuce.mmocore.party.PartyModule;
import net.Indyuce.mmocore.party.PartyUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class McMMOPartyModule
implements PartyModule,
Listener {
    public McMMOPartyModule() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MMOCore.plugin);
    }

    @Override
    @Nullable
    public AbstractParty getParty(PlayerData playerData) {
        McMMOPlayer extPlayerData = UserManager.getPlayer((Player)playerData.getPlayer());
        Party party = extPlayerData == null ? null : extPlayerData.getParty();
        return party == null ? null : new CustomParty(party);
    }

    @EventHandler
    public void onChange(McMMOPartyChangeEvent event) {
        int membersSize;
        Party party;
        if (event.getNewParty() != null && (party = PartyManager.getParty((String)event.getNewParty())) != null && ((membersSize = party.getMembers().size()) != 1 || party.getOnlineMembers().get(0) != event.getPlayer())) {
            party.getOnlineMembers().forEach(p -> PartyUtils.applyStatBonuses(PlayerData.get((OfflinePlayer)p), membersSize + 1));
            PartyUtils.applyStatBonuses(PlayerData.get((OfflinePlayer)event.getPlayer()), membersSize + 1);
        }
        if (event.getOldParty() != null && (party = PartyManager.getParty((String)event.getOldParty())) != null) {
            membersSize = party.getMembers().size() - 1;
            party.getOnlineMembers().forEach(p -> PartyUtils.applyStatBonuses(PlayerData.get((OfflinePlayer)p), membersSize));
            PartyUtils.clearStatBonuses(PlayerData.get((OfflinePlayer)event.getPlayer().getPlayer()));
        }
    }

    private static class CustomParty
    implements AbstractParty {
        private final Party party;

        public CustomParty(Party party) {
            this.party = party;
        }

        @Override
        public boolean hasMember(Player player) {
            return this.party.hasMember(player.getUniqueId());
        }

        @Override
        public List<PlayerData> getOnlineMembers() {
            ArrayList<PlayerData> list = new ArrayList<PlayerData>();
            for (Player online : this.party.getOnlineMembers()) {
                list.add(PlayerData.get((OfflinePlayer)online));
            }
            return list;
        }

        @Override
        public int countMembers() {
            return this.party.getMembers().size();
        }
    }
}

