/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.manager.data.yaml;

import io.lumine.mythic.lib.data.yaml.YAMLSynchronizedDataHandler;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttribute;
import net.Indyuce.mmocore.api.player.profess.PlayerClass;
import net.Indyuce.mmocore.api.player.profess.SavedClassInformation;
import net.Indyuce.mmocore.guild.provided.Guild;
import net.Indyuce.mmocore.manager.data.OfflinePlayerData;
import net.Indyuce.mmocore.manager.data.yaml.YAMLOfflinePlayerData;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skilltree.SkillTreeNode;
import net.Indyuce.mmocore.skilltree.tree.SkillTree;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class YAMLPlayerDataHandler
extends YAMLSynchronizedDataHandler<PlayerData, OfflinePlayerData> {
    public YAMLPlayerDataHandler(Plugin owning) {
        super(owning);
    }

    public void setup() {
    }

    public void close() {
    }

    public void loadFromSection(PlayerData data, ConfigurationSection config) {
        Guild guild;
        data.resetTriggerStats();
        if (!config.contains("class-points")) {
            MMOCore.plugin.playerDataManager.getDefaultData().apply(data);
            return;
        }
        data.setClassPoints(config.getInt("class-points"));
        data.setSkillPoints(config.getInt("skill-points"));
        data.setSkillReallocationPoints(config.getInt("skill-reallocation-points"));
        data.setSkillTreeReallocationPoints(config.getInt("skill-tree-reallocation-points"));
        data.setAttributePoints(config.getInt("attribute-points"));
        data.setAttributeReallocationPoints(config.getInt("attribute-realloc-points"));
        data.setLevel(config.getInt("level"));
        data.setExperience(config.getInt("experience"));
        if (config.contains("class")) {
            data.setClass(MMOCore.plugin.classManager.get(config.getString("class")));
        }
        if (config.contains("guild") && (guild = MMOCore.plugin.nativeGuildManager.getGuild(config.getString("guild"))) != null && guild.hasMember(data.getUniqueId())) {
            data.setGuild(guild);
        }
        if (config.contains("attribute")) {
            data.getAttributes().load(config.getConfigurationSection("attribute"));
        }
        if (data.isOnline()) {
            MMOCore.plugin.attributeManager.getAll().forEach(attribute -> data.getAttributes().getInstance((PlayerAttribute)attribute).updateStats());
        }
        if (config.contains("profession")) {
            data.getCollectionSkills().load(config.getConfigurationSection("profession"));
        }
        if (config.contains("quest")) {
            data.getQuestData().load(config.getConfigurationSection("quest"));
        }
        data.getQuestData().updateBossBar();
        if (config.contains("waypoints")) {
            data.getWaypoints().addAll(config.getStringList("waypoints"));
        }
        if (config.contains("friends")) {
            config.getStringList("friends").forEach(str -> data.getFriends().add(UUID.fromString(str)));
        }
        if (config.contains("skill")) {
            config.getConfigurationSection("skill").getKeys(false).forEach(id -> data.setSkillLevel((String)id, config.getInt("skill." + id)));
        }
        if (config.isConfigurationSection("bound-skills")) {
            for (String key : config.getConfigurationSection("bound-skills").getKeys(false)) {
                ClassSkill skill = data.getProfess().getSkill(config.getString("bound-skills." + key));
                if (skill == null) continue;
                data.bindSkill(Integer.parseInt(key), skill);
            }
        }
        for (SkillTree tree : MMOCore.plugin.skillTreeManager.getAll()) {
            data.setSkillTreePoints(tree.getId(), config.getInt("skill-tree-points." + tree.getId()));
        }
        data.setSkillTreePoints("global", config.getInt("skill-tree-points.global", 0));
        if (config.contains("times-claimed")) {
            for (String key : config.getConfigurationSection("times-claimed").getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection("times-claimed." + key);
                if (section == null) continue;
                for (String key1 : section.getKeys(false)) {
                    ConfigurationSection section1 = section.getConfigurationSection(key1);
                    if (section1 == null) continue;
                    for (String key2 : config.getConfigurationSection("times-claimed." + key + "." + key1).getKeys(false)) {
                        data.getItemClaims().put(key + "." + key1 + "." + key2, config.getInt("times-claimed." + key + "." + key1 + "." + key2));
                    }
                }
            }
        }
        data.setUnlockedItems(config.getStringList("unlocked-items").stream().collect(Collectors.toSet()));
        for (SkillTreeNode node : MMOCore.plugin.skillTreeManager.getAllNodes()) {
            data.setNodeLevel(node, config.getInt("skill-tree-level." + node.getFullId(), 0));
        }
        if (config.contains("class-info")) {
            for (String key : config.getConfigurationSection("class-info").getKeys(false)) {
                try {
                    PlayerClass profess = MMOCore.plugin.classManager.get(key);
                    Validate.notNull((Object)profess, (String)("Could not find class '" + key + "'"));
                    data.applyClassInfo(profess, new SavedClassInformation(config.getConfigurationSection("class-info." + key)));
                }
                catch (IllegalArgumentException exception) {
                    MMOCore.log(Level.WARNING, "Could not load class info '" + key + "': " + exception.getMessage());
                }
            }
        }
        data.setHealth(config.getDouble("health"));
        data.setMana(config.getDouble("mana", data.getStats().getStat("MAX_MANA")));
        data.setStamina(config.getDouble("stamina", data.getStats().getStat("MAX_STAMINA")));
        data.setStellium(config.getDouble("stellium", data.getStats().getStat("MAX_STELLIUM")));
    }

    public void saveInSection(PlayerData data, ConfigurationSection config) {
        config.set("class-points", (Object)data.getClassPoints());
        config.set("skill-points", (Object)data.getSkillPoints());
        config.set("skill-reallocation-points", (Object)data.getSkillReallocationPoints());
        config.set("attribute-points", (Object)data.getAttributePoints());
        config.set("attribute-realloc-points", (Object)data.getAttributeReallocationPoints());
        config.set("level", (Object)data.getLevel());
        config.set("experience", (Object)data.getExperience());
        config.set("class", (Object)data.getProfess().getId());
        config.set("waypoints", new ArrayList<String>(data.getWaypoints()));
        config.set("friends", data.getFriends().stream().map(UUID::toString).collect(Collectors.toList()));
        config.set("last-login", (Object)data.getLastLogin());
        config.set("guild", data.hasGuild() ? data.getGuild().getId() : null);
        config.set("skill-tree-reallocation-points", (Object)data.getSkillTreeReallocationPoints());
        config.set("skill", null);
        config.set("health", (Object)data.getHealth());
        config.set("mana", (Object)data.getMana());
        config.set("stellium", (Object)data.getStellium());
        config.set("stamina", (Object)data.getStamina());
        config.set("unlocked-items", new ArrayList<String>(data.getUnlockedItems()));
        config.set("skill-tree-points", null);
        data.mapSkillTreePoints().forEach((key1, value) -> config.set("skill-tree-points." + key1, value));
        config.set("skill-tree-level", null);
        MMOCore.plugin.skillTreeManager.getAllNodes().forEach(node -> config.set("skill-tree-level." + node.getFullId(), (Object)data.getNodeLevel((SkillTreeNode)node)));
        config.set("skill", null);
        data.mapSkillLevels().forEach((key1, value) -> config.set("skill." + key1, value));
        config.set("times-claimed", null);
        data.getItemClaims().forEach((key, times) -> config.set("times-claimed." + key, times));
        config.set("bound-skills", null);
        data.mapBoundSkills().forEach((slot, skill) -> config.set("bound-skills." + slot, skill));
        config.set("attribute", null);
        config.createSection("attribute");
        data.getAttributes().save(config.getConfigurationSection("attribute"));
        config.set("profession", null);
        config.createSection("profession");
        data.getCollectionSkills().save(config.getConfigurationSection("profession"));
        config.set("quest", null);
        config.createSection("quest");
        data.getQuestData().save(config.getConfigurationSection("quest"));
        config.set("class-info", null);
        for (String key2 : data.getSavedClasses()) {
            SavedClassInformation info = data.getClassInfo(key2);
            config.set("class-info." + key2 + ".level", (Object)info.getLevel());
            config.set("class-info." + key2 + ".experience", (Object)info.getExperience());
            config.set("class-info." + key2 + ".skill-points", (Object)info.getSkillPoints());
            config.set("class-info." + key2 + ".attribute-points", (Object)info.getAttributePoints());
            config.set("class-info." + key2 + ".attribute-realloc-points", (Object)info.getAttributeReallocationPoints());
            config.set("class-info." + key2 + ".skill-tree-reallocation-points", (Object)info.getSkillTreeReallocationPoints());
            config.set("class-info." + key2 + ".skill-reallocation-points", (Object)info.getSkillReallocationPoints());
            config.set("class-info." + key2 + ".health", (Object)info.getHealth());
            config.set("class-info." + key2 + ".mana", (Object)info.getMana());
            config.set("class-info." + key2 + ".stamina", (Object)info.getStamina());
            config.set("class-info." + key2 + ".stellium", (Object)info.getStellium());
            info.getSkillKeys().forEach(skill -> config.set("class-info." + key2 + ".skill." + skill, (Object)info.getSkillLevel((String)skill)));
            info.getAttributeKeys().forEach(attribute -> config.set("class-info." + key2 + ".attribute." + attribute, (Object)info.getAttributeLevel((String)attribute)));
            info.getNodeKeys().forEach(node -> config.set("class-info." + key2 + ".node-levels." + node, (Object)info.getNodeLevel((String)node)));
            info.getSkillTreePointsKeys().forEach(skillTreeId -> config.set("class-info." + key2 + ".skill-tree-points." + skillTreeId, (Object)info.getAttributeLevel((String)skillTreeId)));
            info.mapBoundSkills().forEach((slot, skill) -> config.set("class-info." + key2 + ".bound-skills." + slot, skill));
            config.set("class-info." + key2 + ".unlocked-items", new ArrayList<String>(info.getUnlockedItems()));
        }
    }

    @NotNull
    public OfflinePlayerData getOffline(UUID uuid) {
        return new YAMLOfflinePlayerData(uuid);
    }
}

