/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.manager.data.sql;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.data.sql.SQLDataSource;
import io.lumine.mythic.lib.data.sql.SQLSynchronizedDataHandler;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import java.sql.SQLException;
import java.util.UUID;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.profess.SavedClassInformation;
import net.Indyuce.mmocore.manager.data.OfflinePlayerData;
import net.Indyuce.mmocore.manager.data.sql.MMOCoreDataSynchronizer;
import net.Indyuce.mmocore.manager.data.sql.PlayerDataTableUpdater;
import net.Indyuce.mmocore.manager.data.sql.SQLOfflinePlayerData;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLDataHandler
extends SQLSynchronizedDataHandler<PlayerData, OfflinePlayerData> {
    private static final String[] NEW_COLUMNS = new String[]{"times_claimed", "LONGTEXT", "is_saved", "TINYINT", "skill_reallocation_points", "INT(11)", "skill_tree_reallocation_points", "INT(11)", "skill_tree_points", "LONGTEXT", "skill_tree_levels", "LONGTEXT", "unlocked_items", "LONGTEXT", "health", "FLOAT", "mana", "FLOAT", "stamina", "FLOAT", "stellium", "FLOAT"};

    public SQLDataHandler(SQLDataSource dataSource) {
        super(dataSource);
    }

    public void setup() {
        this.getDataSource().executeUpdateAsync("CREATE TABLE IF NOT EXISTS mmocore_playerdata(uuid VARCHAR(36),class_points INT(11) DEFAULT 0,skill_points INT(11) DEFAULT 0,attribute_points INT(11) DEFAULT 0,attribute_realloc_points INT(11) DEFAULT 0,skill_reallocation_points INT(11) DEFAULT 0,skill_tree_reallocation_points INT(11) DEFAULT 0,skill_tree_points LONGTEXT,skill_tree_levels LONGTEXT,level INT(11) DEFAULT 1,experience INT(11) DEFAULT 0,class VARCHAR(20),guild VARCHAR(20),last_login LONG,attributes LONGTEXT,professions LONGTEXT,times_claimed LONGTEXT,quests LONGTEXT,waypoints LONGTEXT,friends LONGTEXT,skills LONGTEXT,bound_skills LONGTEXT,health FLOAT,mana FLOAT,stamina FLOAT,stellium FLOAT,unlocked_items LONGTEXT,class_info LONGTEXT,is_saved TINYINT,PRIMARY KEY (uuid));");
        for (int i = 0; i < NEW_COLUMNS.length; i += 2) {
            String columnName = NEW_COLUMNS[i];
            String dataType = NEW_COLUMNS[i + 1];
            this.getDataSource().getResultAsync("SELECT * FROM information_schema.COLUMNS WHERE TABLE_NAME = 'mmocore_playerdata' AND COLUMN_NAME = '" + columnName + "'", result -> {
                try {
                    if (!result.next()) {
                        this.getDataSource().executeUpdate("ALTER TABLE mmocore_playerdata ADD COLUMN " + columnName + " " + dataType);
                    }
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            });
        }
    }

    public MMOCoreDataSynchronizer newDataSynchronizer(PlayerData playerData) {
        return new MMOCoreDataSynchronizer(this, playerData);
    }

    public void saveData(PlayerData data, boolean autosave) {
        UUID effectiveId = data.getEffectiveId();
        UtilityMethods.debug((JavaPlugin)MMOCore.plugin, (String)"SQL", (String)("Saving data for: '" + effectiveId + "'..."));
        PlayerDataTableUpdater updater = new PlayerDataTableUpdater(this.getDataSource(), data);
        updater.addData("class_points", data.getClassPoints());
        updater.addData("skill_points", data.getSkillPoints());
        updater.addData("skill_reallocation_points", data.getSkillReallocationPoints());
        updater.addData("attribute_points", data.getAttributePoints());
        updater.addData("attribute_realloc_points", data.getAttributeReallocationPoints());
        updater.addData("skill_tree_reallocation_points", data.getSkillTreeReallocationPoints());
        updater.addData("health", data.getHealth());
        updater.addData("mana", data.getMana());
        updater.addData("stellium", data.getStellium());
        updater.addData("stamina", data.getStamina());
        updater.addData("level", data.getLevel());
        updater.addData("experience", data.getExperience());
        updater.addData("class", data.getProfess().getId());
        updater.addData("last_login", data.getLastLogin());
        updater.addData("guild", data.hasGuild() ? data.getGuild().getId() : null);
        updater.addJSONArray("waypoints", data.getWaypoints());
        updater.addJSONArray("friends", data.getFriends().stream().map(UUID::toString).collect(Collectors.toList()));
        updater.addJSONObject("bound_skills", data.mapBoundSkills().entrySet());
        updater.addJSONObject("skills", data.mapSkillLevels().entrySet());
        updater.addJSONObject("times_claimed", data.getItemClaims().entrySet());
        updater.addJSONObject("skill_tree_points", data.mapSkillTreePoints().entrySet());
        updater.addJSONObject("skill_tree_levels", data.getNodeLevelsEntrySet());
        updater.addData("attributes", data.getAttributes().toJsonString());
        updater.addData("professions", data.getCollectionSkills().toJsonString());
        updater.addData("quests", data.getQuestData().toJsonString());
        updater.addData("class_info", this.createClassInfoData(data).toString());
        updater.addJSONArray("unlocked_items", data.getUnlockedItems());
        if (!autosave) {
            updater.addData("is_saved", 1);
        }
        updater.executeRequest(autosave);
        UtilityMethods.debug((JavaPlugin)MMOCore.plugin, (String)"SQL", (String)("Saved data for: " + effectiveId));
        UtilityMethods.debug((JavaPlugin)MMOCore.plugin, (String)"SQL", (String)String.format("{ class: %s, level: %d }", data.getProfess().getId(), data.getLevel()));
    }

    private JsonObject createClassInfoData(PlayerData playerData) {
        JsonObject json = new JsonObject();
        for (String c : playerData.getSavedClasses()) {
            Object node2;
            Object skill2;
            SavedClassInformation info = playerData.getClassInfo(c);
            JsonObject classinfo = new JsonObject();
            classinfo.addProperty("level", (Number)info.getLevel());
            classinfo.addProperty("experience", (Number)info.getExperience());
            classinfo.addProperty("skill-points", (Number)info.getSkillPoints());
            classinfo.addProperty("attribute-points", (Number)info.getAttributePoints());
            classinfo.addProperty("attribute-realloc-points", (Number)info.getAttributeReallocationPoints());
            classinfo.addProperty("skill-reallocation-points", (Number)info.getSkillReallocationPoints());
            classinfo.addProperty("skill-tree-reallocation-points", (Number)info.getSkillTreeReallocationPoints());
            classinfo.addProperty("health", (Number)info.getHealth());
            classinfo.addProperty("mana", (Number)info.getMana());
            classinfo.addProperty("stamina", (Number)info.getStamina());
            classinfo.addProperty("stellium", (Number)info.getStellium());
            JsonArray array = new JsonArray();
            for (String string : playerData.getUnlockedItems()) {
                array.add(string);
            }
            classinfo.add("unlocked-items", (JsonElement)array);
            JsonObject skillinfo = new JsonObject();
            for (Object skill2 : info.getSkillKeys()) {
                skillinfo.addProperty((String)skill2, (Number)info.getSkillLevel((String)skill2));
            }
            classinfo.add("skill", (JsonElement)skillinfo);
            JsonObject jsonObject = new JsonObject();
            skill2 = info.getAttributeKeys().iterator();
            while (skill2.hasNext()) {
                String string = (String)skill2.next();
                jsonObject.addProperty(string, (Number)info.getAttributeLevel(string));
            }
            classinfo.add("attribute", (JsonElement)jsonObject);
            JsonObject nodeLevelsInfo = new JsonObject();
            for (Object node2 : info.getNodeKeys()) {
                nodeLevelsInfo.addProperty((String)node2, (Number)info.getNodeLevel((String)node2));
            }
            classinfo.add("node-levels", (JsonElement)nodeLevelsInfo);
            JsonObject jsonObject2 = new JsonObject();
            node2 = info.getSkillTreePointsKeys().iterator();
            while (node2.hasNext()) {
                String skillTreeId = (String)node2.next();
                jsonObject2.addProperty(skillTreeId, (Number)info.getSkillTreePoints(skillTreeId));
            }
            classinfo.add("skill-tree-points", (JsonElement)jsonObject2);
            JsonObject boundSkillInfo = new JsonObject();
            for (int slot : info.mapBoundSkills().keySet()) {
                boundSkillInfo.addProperty(String.valueOf(slot), info.mapBoundSkills().get(slot));
            }
            classinfo.add("bound-skills", (JsonElement)boundSkillInfo);
            json.add(c, (JsonElement)classinfo);
        }
        return json;
    }

    private boolean isEmpty(@Nullable String str) {
        return str == null || str.equalsIgnoreCase("null") || str.equalsIgnoreCase("{}") || str.equalsIgnoreCase("[]") || str.equalsIgnoreCase("");
    }

    @NotNull
    public OfflinePlayerData getOffline(UUID uuid) {
        return new SQLOfflinePlayerData(uuid);
    }
}

