/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.manager.StatManager;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerActivity;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarManager
extends BukkitRunnable {
    private int updateTicks;
    private int timeOut;
    private String barFormat;
    private boolean enabled;
    private boolean scheduled;

    public void reload(ConfigurationSection config) {
        this.enabled = config.getBoolean("enabled", false);
        this.timeOut = config.getInt("time-out", 60);
        this.updateTicks = config.getInt("ticks-to-update", 5);
        this.barFormat = config.getString("format", "<No Action Bar Format Found>");
        if (!this.scheduled && this.enabled) {
            this.runTaskTimer((Plugin)MMOCore.plugin, 0L, this.updateTicks);
            this.scheduled = true;
        } else if (this.scheduled && !this.enabled) {
            this.cancel();
            this.scheduled = false;
        }
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void run() {
        for (PlayerData data : PlayerData.getAll()) {
            if (!data.isOnline() || data.getPlayer().isDead() || data.isCasting() || data.getActivityTimeOut(PlayerActivity.ACTION_BAR_MESSAGE) != 0L) continue;
            Placeholders holders = this.getActionBarPlaceholders(data);
            data.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)holders.apply((OfflinePlayer)data.getPlayer(), data.getProfess().hasActionBar() ? data.getProfess().getActionBar() : this.barFormat)));
        }
    }

    public Placeholders getActionBarPlaceholders(PlayerData data) {
        Placeholders holders = new Placeholders();
        holders.register("health", StatManager.format((String)"MAX_HEALTH", (double)data.getPlayer().getHealth()));
        holders.register("max_health", StatManager.format((String)"MAX_HEALTH", (double)data.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        holders.register("mana_icon", data.getProfess().getManaDisplay().getIcon());
        holders.register("mana", StatManager.format((String)"MAX_MANA", (double)data.getMana()));
        holders.register("max_mana", StatManager.format((String)"MAX_MANA", (double)data.getStats().getStat("MAX_MANA")));
        holders.register("stamina", StatManager.format((String)"MAX_STAMINA", (double)data.getStamina()));
        holders.register("max_stamina", StatManager.format((String)"MAX_STAMINA", (double)data.getStats().getStat("MAX_STAMINA")));
        holders.register("stellium", StatManager.format((String)"MAX_STELLIUM", (double)data.getStellium()));
        holders.register("max_stellium", StatManager.format((String)"MAX_STELLIUM", (double)data.getStats().getStat("MAX_STELLIUM")));
        holders.register("class", data.getProfess().getName());
        holders.register("xp", MythicLib.plugin.getMMOConfig().decimal.format(data.getExperience()));
        holders.register("armor", StatManager.format((String)"ARMOR", (double)data.getPlayer().getAttribute(Attribute.GENERIC_ARMOR).getValue()));
        holders.register("level", String.valueOf(data.getLevel()));
        holders.register("name", data.getPlayer().getDisplayName());
        return holders;
    }
}

