/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.loot.chest.condition;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.loot.chest.condition.Condition;
import net.Indyuce.mmocore.loot.chest.condition.ConditionInstance;
import org.apache.commons.lang.Validate;

public class TimeCondition
extends Condition {
    private final int min;
    private final int max;

    public TimeCondition(MMOLineConfig config) {
        super(config);
        Validate.isTrue((boolean)config.contains("min"));
        Validate.isTrue((boolean)config.contains("max"));
        this.min = config.getInt("min");
        this.max = config.getInt("max");
    }

    @Override
    public boolean isMet(ConditionInstance entity) {
        long time = entity.getLocation().getWorld().getTime();
        if (this.min < this.max) {
            return time > (long)this.min && time < (long)this.max;
        }
        return time > (long)this.min || time < (long)this.max;
    }
}

