/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.guild.compat;

import io.lumine.mythic.lib.comp.interaction.relation.Relationship;
import java.util.Objects;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.guild.AbstractGuild;
import net.Indyuce.mmocore.guild.GuildModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;

public class KingdomsXGuildModule
implements GuildModule {
    @Override
    public AbstractGuild getGuild(PlayerData playerData) {
        KingdomPlayer kPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)playerData.getPlayer());
        if (kPlayer == null) {
            return null;
        }
        Kingdom kingdom = kPlayer.getKingdom();
        return kingdom == null ? null : new CustomGuild(kingdom);
    }

    @Override
    public Relationship getRelationship(Player player, Player target) {
        KingdomPlayer player1 = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (player1 == null) {
            return Relationship.GUILD_NEUTRAL;
        }
        Kingdom kingdom1 = player1.getKingdom();
        if (kingdom1 == null) {
            return Relationship.GUILD_NEUTRAL;
        }
        KingdomPlayer player2 = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target.getPlayer());
        if (player2 == null) {
            return Relationship.GUILD_NEUTRAL;
        }
        Kingdom kingdom2 = player2.getKingdom();
        if (kingdom2 == null) {
            return Relationship.GUILD_NEUTRAL;
        }
        return this.adapt(kingdom1.getRelationWith(kingdom2));
    }

    private Relationship adapt(KingdomRelation rel) {
        switch (rel) {
            case ALLY: 
            case SELF: {
                return Relationship.GUILD_ALLY;
            }
            case ENEMY: {
                return Relationship.GUILD_ENEMY;
            }
        }
        return Relationship.GUILD_NEUTRAL;
    }

    class CustomGuild
    implements AbstractGuild {
        @NotNull
        private final Kingdom kingdom;

        CustomGuild(Kingdom kingdom) {
            this.kingdom = Objects.requireNonNull(kingdom);
        }

        @Override
        public boolean hasMember(Player player) {
            return this.kingdom.isMember((OfflinePlayer)player);
        }
    }
}

