/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.guild.compat;

import cc.javajobs.factionsbridge.FactionsBridge;
import cc.javajobs.factionsbridge.bridge.infrastructure.struct.FPlayer;
import cc.javajobs.factionsbridge.bridge.infrastructure.struct.Faction;
import cc.javajobs.factionsbridge.bridge.infrastructure.struct.FactionsAPI;
import cc.javajobs.factionsbridge.bridge.infrastructure.struct.Relationship;
import java.util.Objects;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.guild.AbstractGuild;
import net.Indyuce.mmocore.guild.GuildModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class FactionsGuildModule
implements GuildModule {
    @Override
    public AbstractGuild getGuild(PlayerData playerData) {
        FactionsAPI api = FactionsBridge.getFactionsAPI();
        Faction faction = api.getFaction((OfflinePlayer)playerData.getPlayer());
        return faction == null ? null : new CustomGuild(faction);
    }

    @Override
    public io.lumine.mythic.lib.comp.interaction.relation.Relationship getRelationship(Player player, Player target) {
        FactionsAPI api = FactionsBridge.getFactionsAPI();
        Faction faction = api.getFaction((OfflinePlayer)player);
        if (faction != null) {
            return this.adapt(faction.getRelationshipTo(api.getFPlayer((OfflinePlayer)target)));
        }
        faction = api.getFaction((OfflinePlayer)target);
        if (faction != null) {
            return this.adapt(faction.getRelationshipTo(api.getFPlayer((OfflinePlayer)player)));
        }
        return io.lumine.mythic.lib.comp.interaction.relation.Relationship.GUILD_NEUTRAL;
    }

    private io.lumine.mythic.lib.comp.interaction.relation.Relationship adapt(Relationship rel) {
        switch (rel) {
            case ENEMY: {
                return io.lumine.mythic.lib.comp.interaction.relation.Relationship.GUILD_ENEMY;
            }
            case ALLY: 
            case TRUCE: 
            case MEMBER: {
                return io.lumine.mythic.lib.comp.interaction.relation.Relationship.GUILD_ALLY;
            }
        }
        return io.lumine.mythic.lib.comp.interaction.relation.Relationship.GUILD_NEUTRAL;
    }

    class CustomGuild
    implements AbstractGuild {
        @NotNull
        private final Faction faction;

        CustomGuild(Faction faction) {
            this.faction = Objects.requireNonNull(faction);
        }

        @Override
        public boolean hasMember(Player player) {
            for (FPlayer member : this.faction.getMembers()) {
                if (!member.getUniqueId().equals(player.getUniqueId())) continue;
                return true;
            }
            return false;
        }
    }
}

