/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.social.party;

import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.input.ChatInput;
import net.Indyuce.mmocore.api.util.input.PlayerInput;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.party.provided.Party;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class EditablePartyView
extends EditableInventory {
    private static final NamespacedKey UUID_NAMESPACEDKEY = new NamespacedKey((Plugin)MMOCore.plugin, "Uuid");

    public EditablePartyView() {
        super("party-view");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        return function.equals("member") ? new MemberItem(config) : new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new PartyViewInventory(data, this);
    }

    public static class MemberItem
    extends SimplePlaceholderItem {
        private final InventoryItem empty;
        private final MemberDisplayItem member;

        public MemberItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
            Validate.notNull((Object)config.contains("empty"), (String)"Could not load empty config");
            Validate.notNull((Object)config.contains("member"), (String)"Could not load member config");
            this.empty = new SimplePlaceholderItem(config.getConfigurationSection("empty"));
            this.member = new MemberDisplayItem(this, config.getConfigurationSection("member"));
        }

        @Override
        public ItemStack display(GeneratedInventory inv, int n) {
            Party party = (Party)inv.getPlayerData().getParty();
            return party.getMembers().size() > n ? this.member.display(inv, n) : this.empty.display(inv, n);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public boolean canDisplay(GeneratedInventory inv) {
            return true;
        }
    }

    public class PartyViewInventory
    extends GeneratedInventory {
        public PartyViewInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
        }

        @Override
        public String calculateName() {
            Party party = (Party)this.getPlayerData().getParty();
            return EditablePartyView.this.getName().replace("{max}", "" + MMOCore.plugin.configManager.maxPartyPlayers).replace("{players}", "" + party.getMembers().size());
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            Party party = (Party)this.playerData.getParty();
            if (item.getFunction().equals("leave")) {
                party.removeMember(this.playerData);
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.player.closeInventory();
                return;
            }
            if (item.getFunction().equals("invite")) {
                if (party.getMembers().size() >= MMOCore.plugin.configManager.maxPartyPlayers) {
                    ConfigMessage.fromKey("party-is-full", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return;
                }
                new ChatInput(this.player, PlayerInput.InputType.PARTY_INVITE, context.getInventoryHolder(), (Consumer<String>)((Consumer)input -> {
                    Player target = Bukkit.getPlayer((String)input);
                    if (target == null) {
                        ConfigMessage.fromKey("not-online-player", "player", input).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    long remaining = party.getLastInvite(target) + 120000L - System.currentTimeMillis();
                    if (remaining > 0L) {
                        ConfigMessage.fromKey("party-invite-cooldown", "player", target.getName(), "cooldown", new DelayFormat().format(remaining)).send(this.player);
                        this.open();
                        return;
                    }
                    PlayerData targetData = PlayerData.get((OfflinePlayer)target);
                    if (party.hasMember(target)) {
                        ConfigMessage.fromKey("already-in-party", "player", target.getName()).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    int levelDifference = Math.abs(targetData.getLevel() - party.getLevel());
                    if (levelDifference > MMOCore.plugin.configManager.maxPartyLevelDifference) {
                        ConfigMessage.fromKey("high-level-difference", "player", target.getName(), "diff", String.valueOf(levelDifference)).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    party.sendInvite(this.playerData, targetData);
                    ConfigMessage.fromKey("sent-party-invite", "player", target.getName()).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.open();
                }));
            }
            if (item.getFunction().equals("member") && context.getClickType() == ClickType.RIGHT) {
                if (!party.getOwner().equals(this.playerData)) {
                    return;
                }
                String uuidTag = (String)context.getClickedItem().getItemMeta().getPersistentDataContainer().get(UUID_NAMESPACEDKEY, PersistentDataType.STRING);
                if (uuidTag == null || uuidTag.isEmpty()) {
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuidTag));
                if (target.equals((Object)this.player)) {
                    return;
                }
                party.removeMember(PlayerData.get(target));
                ConfigMessage.fromKey("kick-from-party", "player", target.getName()).send(this.player);
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
    }

    public static class MemberDisplayItem
    extends InventoryItem {
        public MemberDisplayItem(MemberItem memberItem, ConfigurationSection config) {
            super(memberItem, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
            Party party = (Party)inv.getPlayerData().getParty();
            PlayerData member = party.getMembers().get(n);
            Placeholders holders = new Placeholders();
            if (member.isOnline()) {
                holders.register("name", member.getPlayer().getName());
            }
            holders.register("class", member.getProfess().getName());
            holders.register("level", member.getLevel());
            holders.register("since", new DelayFormat(2).format(System.currentTimeMillis() - member.getLastLogin()));
            return holders;
        }

        @NotNull
        public Player getEffectivePlayer(GeneratedInventory inv, int n) {
            return ((Party)inv.getPlayerData().getParty()).getMembers().get(n).getPlayer();
        }

        public ItemStack display(GeneratedInventory inv, int n) {
            Player member = this.getEffectivePlayer(inv, n);
            ItemStack disp = super.display(inv, n);
            ItemMeta meta = disp.getItemMeta();
            meta.getPersistentDataContainer().set(UUID_NAMESPACEDKEY, PersistentDataType.STRING, (Object)member.getUniqueId().toString());
            if (meta instanceof SkullMeta) {
                inv.asyncUpdate(this, n, disp, current -> {
                    ((SkullMeta)meta).setOwningPlayer((OfflinePlayer)member);
                    current.setItemMeta(meta);
                });
            }
            disp.setItemMeta(meta);
            return disp;
        }
    }
}

