/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.social.guild;

import java.util.List;
import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.api.util.input.ChatInput;
import net.Indyuce.mmocore.api.util.input.PlayerInput;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.manager.data.OfflinePlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class EditableGuildView
extends EditableInventory {
    private static final NamespacedKey UUID_NAMESPACEDKEY = new NamespacedKey((Plugin)MMOCore.plugin, "Uuid");

    public EditableGuildView() {
        super("guild-view");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        return function.equals("member") ? new MemberItem(config) : (function.equals("next") || function.equals("previous") || function.equals("disband") || function.equals("invite") ? new ConditionalItem(function, config) : new SimplePlaceholderItem(config));
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new GuildViewInventory(data, this);
    }

    public class MemberItem
    extends SimplePlaceholderItem<GuildViewInventory> {
        private final InventoryItem empty;
        private final MemberDisplayItem member;

        public MemberItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
            Validate.notNull((Object)config.contains("empty"), (String)"Could not load empty config");
            Validate.notNull((Object)config.contains("member"), (String)"Could not load member config");
            this.empty = new SimplePlaceholderItem(config.getConfigurationSection("empty"));
            this.member = new MemberDisplayItem(this, config.getConfigurationSection("member"));
        }

        @Override
        public ItemStack display(GuildViewInventory inv, int n) {
            int index = n * inv.getPage();
            return inv.getPlayerData().getGuild().countMembers() > index ? this.member.display(inv, index) : this.empty.display(inv, index);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }
    }

    public class ConditionalItem
    extends SimplePlaceholderItem<GuildViewInventory> {
        private final String function;

        public ConditionalItem(String func, ConfigurationSection config) {
            super(config);
            this.function = func;
        }

        @Override
        public ItemStack display(GuildViewInventory inv, int n) {
            if (this.function.equals("next") && inv.getPage() == (inv.getPlayerData().getGuild().countMembers() + 20) / inv.getByFunction("member").getSlots().size()) {
                return null;
            }
            if (this.function.equals("previous") && inv.getPage() == 1) {
                return null;
            }
            if ((this.function.equals("disband") || this.function.equals("invite")) && !inv.getPlayerData().getGuild().getOwner().equals(inv.getPlayer().getUniqueId())) {
                return null;
            }
            return super.display(inv, n);
        }
    }

    public class GuildViewInventory
    extends GeneratedInventory {
        private final int maxpages;
        private int page;
        private List<UUID> members;

        public GuildViewInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
            this.page = 1;
            this.maxpages = (playerData.getGuild().countMembers() + 20) / editable.getByFunction("member").getSlots().size();
        }

        @Override
        public void open() {
            this.members = this.playerData.getGuild().listMembers();
            super.open();
        }

        @Override
        public String calculateName() {
            return EditableGuildView.this.getName().replace("{online_players}", "" + this.getPlayerData().getGuild().countOnlineMembers()).replace("{page}", "" + this.page).replace("{maxpages}", "" + this.maxpages).replace("{players}", String.valueOf(this.getPlayerData().getGuild().countMembers())).replace("{tag}", this.getPlayerData().getGuild().getTag()).replace("{name}", this.getPlayerData().getGuild().getName());
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("leave")) {
                this.playerData.getGuild().removeMember(this.playerData.getUniqueId());
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.player.closeInventory();
                return;
            }
            if (item.getFunction().equals("next") && this.page != this.maxpages) {
                ++this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("previous") && this.page != 1) {
                --this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("disband")) {
                if (!this.playerData.getGuild().getOwner().equals(this.playerData.getUniqueId())) {
                    return;
                }
                MMOCore.plugin.nativeGuildManager.unregisterGuild(this.playerData.getGuild());
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.player.closeInventory();
                return;
            }
            if (item.getFunction().equals("invite")) {
                if (!this.playerData.getGuild().getOwner().equals(this.playerData.getUniqueId())) {
                    return;
                }
                new ChatInput(this.player, PlayerInput.InputType.GUILD_INVITE, context.getInventoryHolder(), (Consumer<String>)((Consumer)input -> {
                    Player target = Bukkit.getPlayer((String)input);
                    if (target == null) {
                        ConfigMessage.fromKey("not-online-player", "player", input).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    long remaining = this.playerData.getGuild().getLastInvite(target) + 120000L - System.currentTimeMillis();
                    if (remaining > 0L) {
                        ConfigMessage.fromKey("guild-invite-cooldown", "player", target.getName(), "cooldown", new DelayFormat().format(remaining)).send(this.player);
                        this.open();
                        return;
                    }
                    PlayerData targetData = PlayerData.get((OfflinePlayer)target);
                    if (this.playerData.getGuild().hasMember(targetData.getUniqueId())) {
                        ConfigMessage.fromKey("already-in-guild", "player", target.getName()).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    this.playerData.getGuild().sendGuildInvite(this.playerData, targetData);
                    ConfigMessage.fromKey("sent-guild-invite", "player", target.getName()).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.open();
                }));
            }
            if (item.getFunction().equals("member") && context.getClickType() == ClickType.RIGHT) {
                if (!this.playerData.getGuild().getOwner().equals(this.playerData.getUniqueId())) {
                    return;
                }
                String tag = (String)context.getClickedItem().getItemMeta().getPersistentDataContainer().get(UUID_NAMESPACEDKEY, PersistentDataType.STRING);
                if (tag == null || tag.isEmpty()) {
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(tag));
                if (target.equals((Object)this.player)) {
                    return;
                }
                this.playerData.getGuild().removeMember(target.getUniqueId());
                ConfigMessage.fromKey("kick-from-guild", "player", target.getName()).send(this.player);
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }

        public int getPage() {
            return this.page;
        }
    }

    public static class MemberDisplayItem
    extends InventoryItem<GuildViewInventory> {
        public MemberDisplayItem(MemberItem memberItem, ConfigurationSection config) {
            super(memberItem, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        @NotNull
        public OfflinePlayer getEffectivePlayer(GuildViewInventory inv, int n) {
            return Bukkit.getOfflinePlayer((UUID)((UUID)inv.members.get(n)));
        }

        @Override
        public Placeholders getPlaceholders(GuildViewInventory inv, int n) {
            UUID uuid = (UUID)inv.members.get(n);
            OfflinePlayer player = this.getEffectivePlayer(inv, n);
            Placeholders holders = new Placeholders();
            OfflinePlayerData offline = OfflinePlayerData.get(uuid);
            holders.register("name", MMOCoreUtils.isInvalid(player) ? "???" : player.getName());
            holders.register("class", offline.getProfess().getName());
            holders.register("level", offline.getLevel());
            holders.register("since", new DelayFormat(2).format(System.currentTimeMillis() - offline.getLastLogin()));
            return holders;
        }

        @Override
        public ItemStack display(GuildViewInventory inv, int n) {
            UUID uuid = (UUID)inv.members.get(n);
            ItemStack disp = super.display(inv, n);
            ItemMeta meta = disp.getItemMeta();
            meta.getPersistentDataContainer().set(UUID_NAMESPACEDKEY, PersistentDataType.STRING, (Object)uuid.toString());
            if (meta instanceof SkullMeta) {
                inv.asyncUpdate(this, n, disp, current -> {
                    ((SkullMeta)meta).setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
                    current.setItemMeta(meta);
                });
            }
            disp.setItemMeta(meta);
            return disp;
        }
    }
}

