/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.social.friend;

import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerActivity;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.api.util.input.ChatInput;
import net.Indyuce.mmocore.api.util.input.PlayerInput;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.ErrorPlaceholders;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.manager.InventoryManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class EditableFriendList
extends EditableInventory {
    private static final NamespacedKey UUID_NAMESPACEDKEY = new NamespacedKey((Plugin)MMOCore.plugin, "Uuid");

    public EditableFriendList() {
        super("friend-list");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("friend")) {
            return new FriendItem(config);
        }
        if (function.equals("previous")) {
            return new SimplePlaceholderItem<FriendListInventory>(config){

                @Override
                public boolean canDisplay(FriendListInventory inv) {
                    return inv.page > 0;
                }
            };
        }
        if (function.equals("next")) {
            return new SimplePlaceholderItem<FriendListInventory>(config){

                @Override
                public boolean canDisplay(FriendListInventory inv) {
                    return inv.getEditable().getByFunction("friend").getSlots().size() * inv.page < inv.getPlayerData().getFriends().size();
                }
            };
        }
        return new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new FriendListInventory(data, this);
    }

    class FriendItem
    extends SimplePlaceholderItem {
        private final OnlineFriendItem online;
        private final OfflineFriendItem offline;

        public FriendItem(ConfigurationSection config) {
            super(config);
            Validate.notNull((Object)config.contains("online"), (String)"Could not load online config");
            Validate.notNull((Object)config.contains("offline"), (String)"Could not load offline config");
            this.online = new OnlineFriendItem(this, config.getConfigurationSection("online"));
            this.offline = new OfflineFriendItem(this, config.getConfigurationSection("offline"));
        }

        @Override
        public ItemStack display(GeneratedInventory inv, int n) {
            if (inv.getPlayerData().getFriends().size() <= n) {
                return super.display(inv, n);
            }
            OfflinePlayer friend = Bukkit.getOfflinePlayer((UUID)inv.getPlayerData().getFriends().get(n));
            ItemStack disp = (friend.isOnline() ? this.online : this.offline).display(inv, n);
            ItemMeta meta = disp.getItemMeta();
            meta.getPersistentDataContainer().set(UUID_NAMESPACEDKEY, PersistentDataType.STRING, (Object)friend.getUniqueId().toString());
            if (meta instanceof SkullMeta) {
                inv.asyncUpdate(this, n, disp, current -> {
                    ((SkullMeta)meta).setOwningPlayer(friend);
                    current.setItemMeta(meta);
                });
            }
            disp.setItemMeta(meta);
            return disp;
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public boolean canDisplay(GeneratedInventory inv) {
            return true;
        }
    }

    class FriendListInventory
    extends GeneratedInventory {
        private int page;

        public FriendListInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
        }

        @Override
        public String calculateName() {
            return EditableFriendList.this.getName();
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("previous")) {
                --this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("next")) {
                ++this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("request")) {
                long remaining = this.playerData.getActivityTimeOut(PlayerActivity.FRIEND_REQUEST);
                if (remaining > 0L) {
                    ConfigMessage.fromKey("friend-request-cooldown", "cooldown", new DelayFormat().format(remaining)).send(this.player);
                    return;
                }
                new ChatInput(this.player, PlayerInput.InputType.FRIEND_REQUEST, context.getInventoryHolder(), (Consumer<String>)((Consumer)input -> {
                    Player target = Bukkit.getPlayer((String)input);
                    if (target == null) {
                        ConfigMessage.fromKey("not-online-player", "player", input).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    if (this.playerData.hasFriend(target.getUniqueId())) {
                        ConfigMessage.fromKey("already-friends", "player", target.getName()).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    if (this.playerData.getUniqueId().equals(target.getUniqueId())) {
                        ConfigMessage.fromKey("cant-request-to-yourself", new Object[0]).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    this.playerData.sendFriendRequest(PlayerData.get((OfflinePlayer)target));
                    ConfigMessage.fromKey("sent-friend-request", "player", target.getName()).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.open();
                }));
            }
            if (item.getFunction().equals("friend") && context.getClickType() == ClickType.RIGHT) {
                String tag = (String)context.getClickedItem().getItemMeta().getPersistentDataContainer().get(UUID_NAMESPACEDKEY, PersistentDataType.STRING);
                if (tag == null || tag.isEmpty()) {
                    return;
                }
                InventoryManager.FRIEND_REMOVAL.newInventory(this.playerData, Bukkit.getOfflinePlayer((UUID)UUID.fromString(tag)), this).open();
            }
        }
    }

    class OnlineFriendItem
    extends SimplePlaceholderItem {
        public OnlineFriendItem(FriendItem parent, ConfigurationSection config) {
            super(parent, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        @NotNull
        public OfflinePlayer getEffectivePlayer(GeneratedInventory inv, int n) {
            return Bukkit.getOfflinePlayer((UUID)inv.getPlayerData().getFriends().get(n));
        }

        @Override
        @Deprecated
        public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
            PlayerData friendData = PlayerData.get(this.getEffectivePlayer(inv, n));
            Placeholders holders = new Placeholders();
            if (friendData.isOnline()) {
                holders.register("name", friendData.getPlayer().getName());
            }
            holders.register("class", friendData.getProfess().getName());
            holders.register("level", friendData.getLevel());
            holders.register("online_since", new DelayFormat(2).format(System.currentTimeMillis() - friendData.getLastLogin()));
            return holders;
        }
    }

    class OfflineFriendItem
    extends InventoryItem {
        public OfflineFriendItem(FriendItem parent, ConfigurationSection config) {
            super(parent, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @NotNull
        public OfflinePlayer getEffectivePlayer(GeneratedInventory inv, int n) {
            return Bukkit.getOfflinePlayer((UUID)inv.getPlayerData().getFriends().get(n));
        }

        public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
            OfflinePlayer friend = this.getEffectivePlayer(inv, n);
            if (MMOCoreUtils.isInvalid(friend)) {
                return new ErrorPlaceholders();
            }
            Placeholders holders = new Placeholders();
            holders.register("name", friend.getName());
            holders.register("last_seen", new DelayFormat(2).format(System.currentTimeMillis() - friend.getLastPlayed()));
            return holders;
        }
    }
}

