/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.skilltree;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.skilltree.IntegerCoordinates;
import net.Indyuce.mmocore.skilltree.NodeState;
import net.Indyuce.mmocore.skilltree.NodeType;
import net.Indyuce.mmocore.skilltree.ParentType;
import net.Indyuce.mmocore.skilltree.PathType;
import net.Indyuce.mmocore.skilltree.SkillTreeNode;
import net.Indyuce.mmocore.skilltree.SkillTreePath;
import net.Indyuce.mmocore.skilltree.display.DisplayInfo;
import net.Indyuce.mmocore.skilltree.display.NodeDisplayInfo;
import net.Indyuce.mmocore.skilltree.display.PathDisplayInfo;
import net.Indyuce.mmocore.skilltree.tree.SkillTree;
import net.Indyuce.mmocore.util.Icon;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillTreeViewer
extends EditableInventory {
    protected final Map<DisplayInfo, Icon> icons = new HashMap<DisplayInfo, Icon>();
    protected final Map<NodeState, String> statusNames = new HashMap<NodeState, String>();
    @Nullable
    private final SkillTree defaultSkillTree;

    public SkillTreeViewer() {
        super("skill-tree");
        this.defaultSkillTree = null;
    }

    public SkillTreeViewer(SkillTree initialSkillTree, boolean isDefault) {
        super("specific-skill-tree-" + (isDefault ? "default" : UtilityMethods.ymlName((String)initialSkillTree.getId())));
        this.defaultSkillTree = initialSkillTree;
    }

    @Override
    public void reload(FileConfiguration config) {
        String configPath;
        super.reload(config);
        if (config.contains("status-names")) {
            for (NodeState nodeState : NodeState.values()) {
                this.statusNames.put(nodeState, config.getString("status-names." + UtilityMethods.ymlName((String)nodeState.name()), nodeState.name()));
            }
        }
        for (NodeState status : NodeState.values()) {
            for (PathType pathType : PathType.values()) {
                configPath = "display.paths." + MMOCoreUtils.ymlName(status.name()) + "." + MMOCoreUtils.ymlName(pathType.name());
                if (!config.contains(configPath)) {
                    MMOCore.log(Level.WARNING, "An error occurred while loading skill tree GUI: Missing path type: " + MMOCoreUtils.ymlName(pathType.name()) + " for status: " + MMOCoreUtils.ymlName(status.name()));
                    continue;
                }
                this.icons.put(new PathDisplayInfo(pathType, status), Icon.from(config.get(configPath)));
            }
        }
        for (NodeState status : NodeState.values()) {
            for (Enum enum_ : NodeType.values()) {
                configPath = "display.nodes." + MMOCoreUtils.ymlName(status.name()) + "." + MMOCoreUtils.ymlName(enum_.name());
                if (!config.contains(configPath)) {
                    MMOCore.log(Level.WARNING, "An error occurred while loading skill tree GUI: Missing node type: " + MMOCoreUtils.ymlName(enum_.name()) + " for status: " + MMOCoreUtils.ymlName(status.name()));
                    continue;
                }
                this.icons.put(new NodeDisplayInfo((NodeType)enum_, status), Icon.from(config.get(configPath)));
            }
        }
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("skill-tree")) {
            return new SkillTreeItem(config);
        }
        if (function.equals("up")) {
            return new SimplePlaceholderItem(config);
        }
        if (function.equals("left")) {
            return new SimplePlaceholderItem(config);
        }
        if (function.equals("down")) {
            return new SimplePlaceholderItem(config);
        }
        if (function.equals("right")) {
            return new SimplePlaceholderItem(config);
        }
        if (function.equals("reallocation")) {
            return new InventoryItem<SkillTreeInventory>(config){

                @Override
                public Placeholders getPlaceholders(SkillTreeInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    holders.register("skill-tree-points", inv.getPlayerData().getSkillTreePoints(inv.getSkillTree().getId()));
                    holders.register("global-points", inv.getPlayerData().getSkillTreePoints("global"));
                    holders.register("realloc-points", inv.getPlayerData().getSkillTreeReallocationPoints());
                    int maxPointSpent = inv.getSkillTree().getMaxPointSpent();
                    holders.register("max-point-spent", maxPointSpent == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxPointSpent));
                    holders.register("point-spent", inv.getPlayerData().getPointsSpent(inv.getSkillTree()));
                    return holders;
                }
            };
        }
        if (function.equals("skill-tree-node")) {
            return new SkillTreeNodeItem(config);
        }
        if (function.equals("next-tree-list-page")) {
            return new NextTreeListPageItem(config);
        }
        if (function.equals("previous-tree-list-page")) {
            return new PreviousTreeListPageItem(config);
        }
        return null;
    }

    public SkillTreeInventory newInventory(PlayerData playerData) {
        return new SkillTreeInventory(playerData, this, this.defaultSkillTree);
    }

    public class SkillTreeItem
    extends InventoryItem<SkillTreeInventory> {
        public SkillTreeItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(SkillTreeInventory inv, int n) {
            int index = inv.getEditable().getByFunction("skill-tree").getSlots().size() * inv.treeListPage + n;
            if (inv.skillTrees.size() <= index) {
                return new ItemStack(Material.AIR);
            }
            SkillTree skillTree = (SkillTree)inv.skillTrees.get(index);
            ItemStack item = super.display(inv, n, skillTree.getItem());
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.setDisplayName(skillTree.getName());
            Placeholders holders = this.getPlaceholders(inv, n);
            ArrayList lore = new ArrayList();
            this.getLore().forEach(string -> {
                if (string.contains("{tree-lore}")) {
                    lore.addAll(skillTree.getLore());
                } else {
                    lore.add(holders.apply((OfflinePlayer)inv.getPlayer(), (String)string));
                }
            });
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(skillTree.getCustomModelData()));
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(new NamespacedKey((Plugin)MMOCore.plugin, "skill-tree-id"), PersistentDataType.STRING, (Object)skillTree.getId());
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public Placeholders getPlaceholders(SkillTreeInventory inv, int n) {
            int index = inv.getEditable().getByFunction("skill-tree").getSlots().size() * inv.treeListPage + n;
            SkillTree skillTree = (SkillTree)inv.skillTrees.get(index);
            Placeholders holders = new Placeholders();
            holders.register("name", skillTree.getName());
            holders.register("id", skillTree.getId());
            int maxPointSpent = inv.getSkillTree().getMaxPointSpent();
            holders.register("max-point-spent", maxPointSpent == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxPointSpent));
            holders.register("point-spent", inv.getPlayerData().getPointsSpent(inv.getSkillTree()));
            holders.register("skill-tree-points", inv.getPlayerData().getSkillTreePoints(inv.getSkillTree().getId()));
            holders.register("global-points", inv.getPlayerData().getSkillTreePoints("global"));
            return holders;
        }
    }

    public class SkillTreeNodeItem
    extends InventoryItem<SkillTreeInventory> {
        private final List<String> pathLore;

        public SkillTreeNodeItem(ConfigurationSection config) {
            super(Material.AIR, config);
            this.pathLore = new ArrayList<String>();
            if (config.isList("path-lore")) {
                this.pathLore.addAll(config.getStringList("path-lore"));
            }
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(SkillTreeInventory inv, int n) {
            IntegerCoordinates coordinates = inv.getCoordinates(n);
            if (inv.getSkillTree().isPathOrNode(coordinates)) {
                Icon icon = inv.getIcon(coordinates);
                ItemStack item = super.display(inv, n, icon.getMaterial(), icon.getModelData());
                ItemMeta meta = item.getItemMeta();
                Placeholders holders = this.getPlaceholders(inv, n);
                if (inv.getSkillTree().isNode(coordinates)) {
                    SkillTreeNode node = inv.getSkillTree().getNode(coordinates);
                    ArrayList lore = new ArrayList();
                    this.getLore().forEach(str -> {
                        if (str.contains("{node-lore}")) {
                            node.getLore(inv.getPlayerData()).forEach(s -> lore.add(holders.apply((OfflinePlayer)inv.getPlayer(), str.replace("{node-lore}", (CharSequence)s))));
                        } else if (str.contains("{strong-parents}")) {
                            lore.addAll(this.getParentsLore(inv, node, node.getParents(ParentType.STRONG)));
                        } else if (str.contains("{soft-parents}")) {
                            lore.addAll(this.getParentsLore(inv, node, node.getParents(ParentType.SOFT)));
                        } else if (str.contains("{incompatible-parents}")) {
                            lore.addAll(this.getParentsLore(inv, node, node.getParents(ParentType.INCOMPATIBLE)));
                        } else {
                            lore.add(holders.apply((OfflinePlayer)inv.getPlayer(), (String)str));
                        }
                    });
                    meta.setLore(lore);
                    String name = meta.getDisplayName();
                    meta.setDisplayName(name == null || name.isEmpty() ? node.getName() : name);
                } else {
                    meta.setLore(this.pathLore.stream().map(str -> holders.apply((OfflinePlayer)inv.getPlayer(), (String)str)).collect(Collectors.toList()));
                    meta.setDisplayName(" ");
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                PersistentDataContainer container = meta.getPersistentDataContainer();
                container.set(new NamespacedKey((Plugin)MMOCore.plugin, "coordinates.x"), PersistentDataType.INTEGER, (Object)coordinates.getX());
                container.set(new NamespacedKey((Plugin)MMOCore.plugin, "coordinates.y"), PersistentDataType.INTEGER, (Object)coordinates.getY());
                item.setItemMeta(meta);
                return item;
            }
            return new ItemStack(Material.AIR);
        }

        public List<String> getParentsLore(SkillTreeInventory inv, SkillTreeNode node, Collection<SkillTreeNode> parents) {
            ArrayList<String> lore = new ArrayList<String>();
            for (SkillTreeNode parent : parents) {
                int level = inv.getPlayerData().getNodeLevel(parent);
                ChatColor color = level >= node.getParentNeededLevel(parent) ? ChatColor.GREEN : ChatColor.RED;
                lore.add(ChatColor.GRAY + "\u25c6" + parent.getName() + ": " + color + node.getParentNeededLevel(parent));
            }
            return lore;
        }

        @Override
        public Placeholders getPlaceholders(SkillTreeInventory inv, int n) {
            Placeholders holders = new Placeholders();
            holders.register("skill-tree", inv.getSkillTree().getName());
            boolean isNode = inv.getSkillTree().isNode(inv.getCoordinates(n));
            if (isNode) {
                SkillTreeNode node = inv.getNode(n);
                holders.register("current-level", inv.getPlayerData().getNodeLevel(node));
                NodeState status = inv.getPlayerData().getNodeState(node);
                holders.register("current-state", SkillTreeViewer.this.statusNames.getOrDefault((Object)status, status.name()));
                holders.register("max-level", node.getMaxLevel());
                holders.register("name", node.getName());
                holders.register("max-children", node.getMaxChildren());
                holders.register("point-consumed", node.getPointConsumption());
                holders.register("display-type", (Object)node.getNodeType());
            } else {
                holders.register("display-type", (Object)inv.skillTree.getPath(inv.getCoordinates(n)).getPathType());
            }
            int maxPointSpent = inv.getSkillTree().getMaxPointSpent();
            holders.register("max-point-spent", maxPointSpent == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxPointSpent));
            holders.register("point-spent", inv.getPlayerData().getPointsSpent(inv.getSkillTree()));
            holders.register("skill-tree-points", inv.getPlayerData().getSkillTreePoints(inv.getSkillTree().getId()));
            holders.register("global-points", inv.getPlayerData().getSkillTreePoints("global"));
            return holders;
        }
    }

    public class NextTreeListPageItem
    extends SimplePlaceholderItem<SkillTreeInventory> {
        public NextTreeListPageItem(ConfigurationSection config) {
            super(config);
        }

        @Override
        public boolean canDisplay(SkillTreeInventory inv) {
            return inv.getTreeListPage() < inv.getMaxTreeListPage();
        }
    }

    public class PreviousTreeListPageItem
    extends SimplePlaceholderItem<SkillTreeInventory> {
        public PreviousTreeListPageItem(ConfigurationSection config) {
            super(config);
        }

        @Override
        public boolean canDisplay(SkillTreeInventory inv) {
            return inv.getTreeListPage() > 0;
        }
    }

    public class SkillTreeInventory
    extends GeneratedInventory {
        private int x;
        private int y;
        private int minSlot;
        private int maxSlot;
        private final int width;
        private final int height;
        private int treeListPage;
        private final int maxTreeListPage;
        private final List<SkillTree> skillTrees;
        @NotNull
        private SkillTree skillTree;
        private final List<Integer> slots;

        public SkillTreeInventory(PlayerData playerData, EditableInventory editable, SkillTree skillTree) {
            super(playerData, editable);
            this.skillTrees = playerData.getProfess().getSkillTrees();
            this.skillTree = skillTree == null ? this.skillTrees.get(0) : skillTree;
            this.maxTreeListPage = skillTree == null ? (this.skillTrees.size() - 1) / editable.getByFunction("skill-tree").getSlots().size() : 0;
            this.slots = editable.getByFunction("skill-tree-node").getSlots();
            this.minSlot = 64;
            this.maxSlot = 0;
            for (int slot : this.slots) {
                if (slot < this.minSlot) {
                    this.minSlot = slot;
                }
                if (slot <= this.maxSlot) continue;
                this.maxSlot = slot;
            }
            this.width = (this.maxSlot - this.minSlot) % 9;
            this.height = (this.maxSlot - this.minSlot) / 9;
            this.x -= this.width / 2;
            this.y -= this.height / 2;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getTreeListPage() {
            return this.treeListPage;
        }

        public int getMaxTreeListPage() {
            return this.maxTreeListPage;
        }

        public Icon getIcon(IntegerCoordinates coordinates) {
            NodeState pathStatus;
            if (this.skillTree.isNode(coordinates)) {
                SkillTreeNode node = this.skillTree.getNode(coordinates);
                NodeType nodeType = node.getNodeType();
                NodeState nodeState = this.playerData.getNodeState(node);
                if (node.hasIcon(nodeState)) {
                    return node.getIcon(nodeState);
                }
                NodeDisplayInfo displayInfo = new NodeDisplayInfo(nodeType, nodeState);
                if (this.skillTree.hasIcon(displayInfo)) {
                    return this.skillTree.getIcon(displayInfo);
                }
                Icon icon = SkillTreeViewer.this.icons.get(displayInfo);
                Validate.notNull((Object)icon, (String)("The node " + node.getFullId() + " has no icon for the type " + (Object)((Object)nodeType) + " and the status " + (Object)((Object)nodeState)));
                return icon;
            }
            SkillTreePath path = this.skillTree.getPath(coordinates);
            PathType pathType = path.getPathType();
            PathDisplayInfo displayInfo = new PathDisplayInfo(pathType, pathStatus = path.getStatus(this.playerData));
            if (this.skillTree.hasIcon(displayInfo)) {
                return this.skillTree.getIcon(displayInfo);
            }
            Icon icon = SkillTreeViewer.this.icons.get(displayInfo);
            Validate.notNull((Object)icon, (String)("There is no icon for the path type " + (Object)((Object)pathType) + " and the status " + (Object)((Object)pathStatus)));
            return icon;
        }

        @Override
        public String calculateName() {
            return this.getEditable().getName().replace("{skill-tree-name}", this.skillTree.getName()).replace("{skill-tree-id}", this.skillTree.getId());
        }

        public IntegerCoordinates getCoordinates(int n) {
            int slot = this.slots.get(n);
            int deltaX = (slot - this.getMinSlot()) % 9;
            int deltaY = (slot - this.getMinSlot()) / 9;
            IntegerCoordinates coordinates = new IntegerCoordinates(this.getX() + deltaX, this.getY() + deltaY);
            return coordinates;
        }

        public SkillTreeNode getNode(int n) {
            return this.getSkillTree().getNode(this.getCoordinates(n));
        }

        public SkillTree getSkillTree() {
            return this.skillTree;
        }

        public int getMinSlot() {
            return this.minSlot;
        }

        @Override
        public void whenClicked(InventoryClickContext event, InventoryItem item) {
            if (item.getFunction().equals("next-tree-list-page")) {
                ++this.treeListPage;
                this.open();
            }
            if (item.getFunction().equals("up")) {
                this.y -= MMOCore.plugin.configManager.skillTreeScrollStepY;
                this.open();
            }
            if (item.getFunction().equals("right")) {
                this.x += MMOCore.plugin.configManager.skillTreeScrollStepX;
                this.open();
            }
            if (item.getFunction().equals("down")) {
                this.y += MMOCore.plugin.configManager.skillTreeScrollStepY;
                this.open();
            }
            if (item.getFunction().equals("left")) {
                this.x -= MMOCore.plugin.configManager.skillTreeScrollStepX;
                this.open();
            }
            if (item.getFunction().equals("previous-tree-list-page")) {
                --this.treeListPage;
                this.open();
            }
            if (item.getFunction().equals("reallocation")) {
                int spent = this.playerData.getPointsSpent(this.skillTree);
                if (spent < 1) {
                    ConfigMessage.fromKey("no-skill-tree-points-spent", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                if (this.getPlayerData().getSkillTreeReallocationPoints() <= 0) {
                    ConfigMessage.fromKey("not-skill-tree-reallocation-point", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                int reallocated = this.playerData.getPointsSpent(this.skillTree);
                this.playerData.giveSkillTreePoints(this.skillTree.getId(), reallocated);
                this.playerData.giveSkillTreeReallocationPoints(-1);
                this.playerData.resetSkillTree(this.skillTree);
                this.skillTree.setupNodeStates(this.playerData);
                ConfigMessage.fromKey("reallocated-points", "points", "" + this.playerData.getSkillTreePoints(this.skillTree.getId()), "skill-tree", this.skillTree.getName()).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.RESET_SKILL_TREE).playTo(this.player);
                this.open();
                return;
            }
            if (item.getFunction().equals("skill-tree")) {
                String id = (String)event.getClickedItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)MMOCore.plugin, "skill-tree-id"), PersistentDataType.STRING);
                MMOCore.plugin.soundManager.getSound(SoundEvent.CHANGE_SKILL_TREE).playTo(this.player);
                this.skillTree = (SkillTree)MMOCore.plugin.skillTreeManager.get(id);
                this.open();
                return;
            }
            if (item.getFunction().equals("skill-tree-node") && event.getClickType() == ClickType.LEFT) {
                int y;
                PersistentDataContainer container = event.getClickedItem().getItemMeta().getPersistentDataContainer();
                int x = (Integer)container.get(new NamespacedKey((Plugin)MMOCore.plugin, "coordinates.x"), PersistentDataType.INTEGER);
                if (!this.skillTree.isNode(new IntegerCoordinates(x, y = ((Integer)container.get(new NamespacedKey((Plugin)MMOCore.plugin, "coordinates.y"), PersistentDataType.INTEGER)).intValue()))) {
                    return;
                }
                SkillTreeNode node = this.skillTree.getNode(new IntegerCoordinates(x, y));
                if (this.playerData.getPointsSpent(this.skillTree) >= this.skillTree.getMaxPointSpent()) {
                    ConfigMessage.fromKey("max-points-reached", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                switch (this.playerData.canIncrementNodeLevel(node)) {
                    case SUCCESS: {
                        this.playerData.incrementNodeLevel(node);
                        ConfigMessage.fromKey("upgrade-skill-node", "skill-node", node.getName(), "level", "" + this.playerData.getNodeLevel(node)).send(this.player);
                        MMOCore.plugin.soundManager.getSound(SoundEvent.LEVEL_SKILL_TREE_NODE).playTo(this.getPlayer());
                        this.open();
                        break;
                    }
                    case PERMISSION_DENIED: {
                        ConfigMessage.fromKey("missing-skill-node-permission", new Object[0]).send(this.player);
                        MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                        break;
                    }
                    case LOCKED_NODE: {
                        ConfigMessage.fromKey("locked-node", new Object[0]).send(this.player);
                        MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                        break;
                    }
                    case MAX_LEVEL_REACHED: {
                        ConfigMessage.fromKey("skill-node-max-level-hit", new Object[0]).send(this.player);
                        MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                        break;
                    }
                    case NOT_ENOUGH_POINTS: {
                        ConfigMessage.fromKey("not-enough-skill-tree-points", "point", "" + node.getPointConsumption()).send(this.player);
                        MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    }
                }
            }
        }
    }
}

