/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.api.item;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.PluginInventory;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryItem<T extends GeneratedInventory> {
    private final String id;
    private final String function;
    private final List<Integer> slots = new ArrayList<Integer>();
    @Nullable
    private final InventoryItem<?> parent;
    private final Material material;
    private final String name;
    private final String texture;
    private final List<String> lore;
    private final int modelData;
    private final boolean hideFlags;
    private final boolean hideTooltip;

    public InventoryItem(ConfigurationSection config) {
        this((InventoryItem)null, config);
    }

    public InventoryItem(@Nullable InventoryItem<?> parent, ConfigurationSection config) {
        this(parent, Material.valueOf((String)config.getString("item", "").toUpperCase().replace(" ", "_").replace("-", "_")), config);
    }

    public InventoryItem(@NotNull Material material, ConfigurationSection config) {
        this(null, material, config);
    }

    public InventoryItem(InventoryItem<?> parent, Material material, ConfigurationSection config) {
        this.id = config.getName();
        this.function = config.getString("function", "");
        this.parent = parent;
        this.material = material;
        this.name = config.getString("name");
        this.lore = config.getStringList("lore");
        this.hideFlags = config.getBoolean("hide-flags");
        this.hideTooltip = config.getBoolean("hide-tooltip") && MythicLib.plugin.getVersion().isAbove(new int[]{1, 20, 5});
        this.texture = config.getString("texture");
        this.modelData = config.getInt("custom-model-data");
        config.getStringList("slots").forEach(str -> this.slots.add(Integer.parseInt(str)));
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getFunction() {
        return this.parent == null ? this.function : this.parent.function;
    }

    public boolean hasFunction() {
        return !this.getFunction().isEmpty();
    }

    @NotNull
    public List<Integer> getSlots() {
        return this.parent == null ? this.slots : this.parent.slots;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean hideFlags() {
        return this.hideFlags;
    }

    public boolean hideTooltip() {
        return this.hideTooltip;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<String> getLore() {
        return this.lore;
    }

    public int getModelData() {
        return this.modelData;
    }

    public void setDisplayed(Inventory inv, T generated) {
        ((GeneratedInventory)generated).addLoaded(this);
        if (!this.hasDifferentDisplay()) {
            ItemStack display = this.display(generated);
            for (int slot : this.getSlots()) {
                inv.setItem(slot, display);
            }
        } else {
            for (int j = 0; j < this.slots.size(); ++j) {
                inv.setItem(this.slots.get(j).intValue(), this.display(generated, j));
            }
        }
    }

    public boolean hasDifferentDisplay() {
        return false;
    }

    public boolean canDisplay(T inv) {
        return true;
    }

    @NotNull
    public ItemStack display(T inv) {
        return this.display(inv, 0);
    }

    @NotNull
    public ItemStack display(T inv, int n) {
        return this.display(inv, n, this.material);
    }

    @NotNull
    public ItemStack display(T inv, int n, Material specificMaterial) {
        return this.display(inv, n, specificMaterial, this.modelData);
    }

    @NotNull
    public ItemStack display(T inv, int n, Material material, int modelData) {
        Placeholders placeholders = this.getPlaceholders(inv, n);
        OfflinePlayer effectivePlayer = this.getEffectivePlayer(inv, n);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(modelData));
        if (this.texture != null && meta instanceof SkullMeta) {
            UtilityMethods.setTextureValue((SkullMeta)((SkullMeta)meta), (String)this.texture);
        }
        if (this.hasName()) {
            meta.setDisplayName(placeholders.apply(effectivePlayer, this.getName()));
        }
        if (this.hideTooltip()) {
            meta.setHideTooltip(true);
        }
        if (this.hideFlags()) {
            MMOCoreUtils.addAllItemFlags(meta);
        }
        if (this.hasLore()) {
            ArrayList lore = new ArrayList();
            this.getLore().forEach(line -> lore.add(ChatColor.GRAY + placeholders.apply(effectivePlayer, (String)line)));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public OfflinePlayer getEffectivePlayer(T inv, int n) {
        return ((PluginInventory)inv).getPlayer();
    }

    public Placeholders getPlaceholders(T inv) {
        return this.getPlaceholders(inv, 0);
    }

    public abstract Placeholders getPlaceholders(T var1, int var2);
}

