/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.api.adaptor;

import io.lumine.mythic.lib.MythicLib;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.adaptor.Adaptor;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ClassicAdaptor
extends Adaptor {
    private Inventory open;

    public ClassicAdaptor(GeneratedInventory generated) {
        super(generated);
    }

    @Override
    public void open() {
        this.open = this.getInventory();
        this.generated.getPlayer().openInventory(this.open);
    }

    @Override
    public void close() {
    }

    @Override
    public void asyncUpdate(InventoryItem<?> item, int n, ItemStack placed, Consumer<ItemStack> update) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)MMOCore.plugin, () -> {
            update.accept(placed);
            this.open.setItem(item.getSlots().get(n).intValue(), placed);
        });
    }

    @Override
    public <T> void asyncUpdate(CompletableFuture<T> future, InventoryItem<?> item, int n, ItemStack placed, BiConsumer<T, ItemStack> update) {
        future.thenAccept(t -> {
            update.accept(t, placed);
            this.open.setItem(item.getSlots().get(n).intValue(), placed);
        });
    }

    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this.generated, (int)this.generated.getEditable().getSlots(), (String)MythicLib.plugin.getPlaceholderParser().parse((OfflinePlayer)this.generated.getPlayer(), this.generated.calculateName()));
        for (InventoryItem item : this.generated.getEditable().getItems()) {
            if (!item.canDisplay(this.generated)) continue;
            this.setDisplayed(inv, item);
        }
        return inv;
    }

    private void setDisplayed(Inventory inv, InventoryItem item) {
        this.generated.addLoaded(item);
        List<Integer> slots = item.getSlots();
        if (!item.hasDifferentDisplay()) {
            ItemStack display = item.display(this.generated);
            for (int slot : slots) {
                inv.setItem(slot, display);
            }
        } else {
            for (int j = 0; j < slots.size(); ++j) {
                inv.setItem(slots.get(j).intValue(), item.display(this.generated, j));
            }
        }
    }
}

