/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.PluginInventory;
import net.Indyuce.mmocore.gui.api.adaptor.Adaptor;
import net.Indyuce.mmocore.gui.api.adaptor.ClassicAdaptor;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.TriggerItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class GeneratedInventory
extends PluginInventory {
    private final EditableInventory editable;
    private final List<InventoryItem> loaded = new ArrayList<InventoryItem>();
    private final Adaptor adaptor;

    public GeneratedInventory(PlayerData playerData, EditableInventory editable) {
        super(playerData);
        this.editable = editable;
        this.adaptor = editable.getAdaptorType().supply(this);
    }

    public List<InventoryItem> getLoaded() {
        return this.loaded;
    }

    public EditableInventory getEditable() {
        return this.editable;
    }

    public InventoryItem getByFunction(String function) {
        for (InventoryItem item : this.loaded) {
            if (!item.getFunction().equals(function)) continue;
            return item;
        }
        return null;
    }

    public InventoryItem getBySlot(int slot) {
        for (InventoryItem item : this.loaded) {
            if (!item.getSlots().contains(slot)) continue;
            return item;
        }
        return null;
    }

    public void addLoaded(InventoryItem item) {
        this.loaded.add(0, item);
    }

    public Inventory getInventory() {
        Validate.isTrue((boolean)(this.adaptor instanceof ClassicAdaptor));
        return ((ClassicAdaptor)this.adaptor).getInventory();
    }

    @Override
    public void open() {
        if (!this.getPlayerData().isOnline()) {
            return;
        }
        this.loaded.clear();
        this.adaptor.open();
    }

    public void asyncUpdate(InventoryItem<?> item, int n, ItemStack placed, Consumer<ItemStack> update) {
        this.adaptor.asyncUpdate(item, n, placed, update);
    }

    public <T> void asyncUpdate(CompletableFuture<T> future, InventoryItem<?> item, int n, ItemStack placed, BiConsumer<T, ItemStack> update) {
        this.adaptor.asyncUpdate(future, item, n, placed, update);
    }

    @Override
    public void whenClicked(InventoryClickContext context) {
        context.setCancelled(true);
        InventoryItem item = this.getBySlot(context.getSlot());
        if (item == null || context.getClickedItem() == null || context.getClickedItem().getType() == Material.AIR) {
            return;
        }
        if (item instanceof TriggerItem) {
            ((TriggerItem)item).getTrigger().apply(this.getPlayerData());
        } else {
            this.whenClicked(context, item);
        }
    }

    public abstract String calculateName();

    public abstract void whenClicked(@NotNull InventoryClickContext var1, @NotNull InventoryItem var2);
}

