/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.player.Unlockable;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.RegisteredSkill;
import net.Indyuce.mmocore.skill.binding.SkillSlot;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class SkillList
extends EditableInventory {
    public SkillList() {
        super("skill-list");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("skill")) {
            return new SkillItem(config);
        }
        if (function.equals("level")) {
            return new LevelItem(config);
        }
        if (function.equals("upgrade")) {
            return new UpgradeItem(config);
        }
        if (function.equals("reallocation")) {
            return new InventoryItem(config){

                public Placeholders getPlaceholders(GeneratedInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    holders.register("skill_points", inv.getPlayerData().getSkillPoints());
                    holders.register("points", inv.getPlayerData().getSkillReallocationPoints());
                    holders.register("total", inv.getPlayerData().countSkillPointsSpent());
                    return holders;
                }
            };
        }
        if (function.equals("slot")) {
            return new SlotItem(config);
        }
        if (function.equals("previous")) {
            return new SimplePlaceholderItem<SkillViewerInventory>(config){

                @Override
                public boolean canDisplay(SkillViewerInventory inv) {
                    return inv.page > 0;
                }
            };
        }
        if (function.equals("next")) {
            return new SimplePlaceholderItem<SkillViewerInventory>(config){

                @Override
                public boolean canDisplay(SkillViewerInventory inv) {
                    int perPage = inv.skillSlots.size();
                    return inv.page < (inv.skills.size() - 1) / perPage;
                }
            };
        }
        if (function.equals("selected")) {
            return new SelectedItem(config);
        }
        return new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new SkillViewerInventory(data, this);
    }

    public class SkillItem
    extends InventoryItem<SkillViewerInventory> {
        public SkillItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(SkillViewerInventory inv, int n) {
            int index = n + inv.skillSlots.size() * inv.page;
            if (index >= inv.skills.size()) {
                return new ItemStack(Material.AIR);
            }
            ClassSkill skill = (ClassSkill)inv.skills.get(index);
            Placeholders holders = this.getPlaceholders(inv.getPlayerData(), skill);
            ArrayList<String> lore = new ArrayList<String>(this.getLore());
            index = lore.indexOf("{lore}");
            lore.remove(index);
            List<String> skillLore = skill.calculateLore(inv.getPlayerData());
            for (int j = 0; j < skillLore.size(); ++j) {
                lore.add(index + j, skillLore.get(j));
            }
            boolean unlocked = skill.getUnlockLevel() <= inv.getPlayerData().getLevel();
            lore.removeIf(next -> next.startsWith("{unlocked}") && !unlocked || next.startsWith("{locked}") && unlocked || next.startsWith("{max_level}") && (!skill.hasMaxLevel() || skill.getMaxLevel() > inv.getPlayerData().getSkillLevel(skill.getSkill())));
            for (int j = 0; j < lore.size(); ++j) {
                lore.set(j, ChatColor.GRAY + holders.apply((OfflinePlayer)inv.getPlayer(), (String)lore.get(j)));
            }
            ItemStack item = skill.getSkill().getIcon();
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(holders.apply((OfflinePlayer)inv.getPlayer(), this.getName()));
            meta.addItemFlags(ItemFlag.values());
            meta.setLore(lore);
            item.setItemMeta(meta);
            return NBTItem.get((ItemStack)item).addTag(new ItemTag[]{new ItemTag("skillId", (Object)skill.getSkill().getHandler().getId())}).toItem();
        }

        public Placeholders getPlaceholders(PlayerData player, ClassSkill skill) {
            Placeholders holders = new Placeholders();
            holders.register("skill", skill.getSkill().getName());
            holders.register("unlock", "" + skill.getUnlockLevel());
            holders.register("level", "" + player.getSkillLevel(skill.getSkill()));
            return holders;
        }

        @Override
        public Placeholders getPlaceholders(SkillViewerInventory inv, int n) {
            return new Placeholders();
        }
    }

    public class LevelItem
    extends InventoryItem<SkillViewerInventory> {
        private final int offset;

        public LevelItem(ConfigurationSection config) {
            super(config);
            this.offset = config.getInt("offset");
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(SkillViewerInventory inv, int n) {
            int j;
            ClassSkill skill = inv.selected;
            int skillLevel = inv.getPlayerData().getSkillLevel(skill.getSkill()) + n - this.offset;
            if (skillLevel < 1) {
                return new ItemStack(Material.AIR);
            }
            ArrayList<String> lore = new ArrayList<String>(this.getLore());
            int index = lore.indexOf("{lore}");
            lore.remove(index);
            List<String> skillLore = skill.calculateLore(inv.getPlayerData(), skillLevel);
            for (j = 0; j < skillLore.size(); ++j) {
                lore.add(index + j, skillLore.get(j));
            }
            for (j = 0; j < lore.size(); ++j) {
                lore.set(j, ChatColor.GRAY + MMOCore.plugin.placeholderParser.parse((OfflinePlayer)inv.getPlayer(), (String)lore.get(j)));
            }
            ItemStack item = new ItemStack(this.getMaterial());
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MMOCore.plugin.placeholderParser.parse((OfflinePlayer)inv.getPlayer(), this.getName().replace("{skill}", skill.getSkill().getName()).replace("{roman}", MMOCoreUtils.intToRoman(skillLevel)).replace("{level}", "" + skillLevel)));
            meta.addItemFlags(ItemFlag.values());
            meta.setLore(lore);
            if (MythicLib.plugin.getVersion().isStrictlyHigher(new int[]{1, 13})) {
                meta.setCustomModelData(Integer.valueOf(this.getModelData()));
            }
            item.setItemMeta(meta);
            return NBTItem.get((ItemStack)item).addTag(new ItemTag[]{new ItemTag("skillId", (Object)skill.getSkill().getHandler().getId())}).toItem();
        }

        @Override
        public Placeholders getPlaceholders(SkillViewerInventory inv, int n) {
            return new Placeholders();
        }
    }

    public class UpgradeItem
    extends InventoryItem<SkillViewerInventory> {
        private int shiftCost;

        public UpgradeItem(ConfigurationSection config) {
            super(config);
            this.shiftCost = 1;
            if (config.contains("shift-cost")) {
                this.shiftCost = config.getInt("shift-cost");
                if (this.shiftCost < 1) {
                    MMOCore.log(Level.WARNING, "Upgrade shift-cost cannot be less than 1. Using default value: 1");
                    this.shiftCost = 1;
                }
            }
        }

        @Override
        public Placeholders getPlaceholders(SkillViewerInventory inv, int n) {
            RegisteredSkill selected = inv.selected == null ? null : inv.selected.getSkill();
            Placeholders holders = new Placeholders();
            holders.register("skill_caps", selected.getName().toUpperCase());
            holders.register("skill", selected.getName());
            holders.register("skill_points", "" + inv.getPlayerData().getSkillPoints());
            holders.register("shift_points", this.shiftCost);
            return holders;
        }
    }

    public class SlotItem
    extends InventoryItem<SkillViewerInventory> {
        private final String none;
        @Nullable
        private final Material filledItem;
        private final int filledCMD;

        public SlotItem(ConfigurationSection config) {
            super(config);
            this.none = MythicLib.plugin.parseColors(config.getString("no-skill"));
            this.filledItem = config.contains("filled-item") ? Material.valueOf((String)config.getString("filled-item").toUpperCase().replace("-", "_").replace(" ", "_")) : null;
            this.filledCMD = config.getInt("filled-custom-model-data", this.getModelData());
        }

        @Override
        public ItemStack display(SkillViewerInventory inv, int n) {
            int j;
            ItemMeta meta;
            ItemStack item;
            SkillSlot skillSlot = inv.getPlayerData().getProfess().getSkillSlot(n + 1);
            if (skillSlot == null || !inv.getPlayerData().hasUnlocked(skillSlot)) {
                return new ItemStack(Material.AIR);
            }
            ClassSkill boundSkill = inv.getPlayerData().getBoundSkill(n + 1);
            if (boundSkill == null) {
                item = super.display(inv, n);
                meta = item.getItemMeta();
            } else if (this.filledItem == null) {
                item = boundSkill.getSkill().getIcon();
                meta = item.getItemMeta();
            } else {
                item = new ItemStack(this.filledItem);
                meta = item.getItemMeta();
                meta.setCustomModelData(Integer.valueOf(this.filledCMD));
            }
            Placeholders holders = this.getPlaceholders(inv, n);
            meta.setDisplayName(MMOCore.plugin.placeholderParser.parse((OfflinePlayer)inv.getPlayerData().getPlayer(), skillSlot.getName()));
            ArrayList<String> lore = new ArrayList<String>(this.getLore());
            int index = lore.indexOf("{slot-lore}");
            if (index != -1) {
                lore.remove(index);
                List<String> slotLore = skillSlot.getLore();
                for (j = 0; j < slotLore.size(); ++j) {
                    lore.add(index + j, slotLore.get(j));
                }
            }
            if ((index = lore.indexOf("{skill-lore}")) != -1) {
                lore.remove(index);
                List<Object> skillLore = boundSkill == null ? new ArrayList() : boundSkill.calculateLore(inv.getPlayerData());
                for (j = 0; j < skillLore.size(); ++j) {
                    lore.add(index + j, (String)skillLore.get(j));
                }
            }
            for (int j2 = 0; j2 < lore.size(); ++j2) {
                lore.set(j2, ChatColor.GRAY + holders.apply((OfflinePlayer)inv.getPlayer(), (String)lore.get(j2)));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public Placeholders getPlaceholders(SkillViewerInventory inv, int n) {
            RegisteredSkill selected = inv.selected.getSkill();
            @NotNull SkillSlot skillSlot = inv.getPlayerData().getProfess().getSkillSlot(n + 1);
            Placeholders holders = new Placeholders();
            holders.register("slot", skillSlot.getName());
            holders.register("selected", selected == null ? this.none : selected.getName());
            RegisteredSkill skill = inv.getPlayerData().hasSkillBound(n + 1) ? inv.getPlayerData().getBoundSkill(n + 1).getSkill() : null;
            holders.register("skill", skill == null ? this.none : skill.getName());
            return holders;
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }
    }

    public class SelectedItem
    extends InventoryItem<SkillViewerInventory> {
        public SelectedItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
        }

        @Override
        public ItemStack display(SkillViewerInventory inv, int n) {
            if (inv.selected == null) {
                return new ItemStack(Material.AIR);
            }
            Placeholders holders = this.getPlaceholders(inv, n);
            ItemStack item = new ItemStack(inv.selected.getSkill().getIcon());
            ItemMeta meta = item.getItemMeta();
            int skillLevel = inv.getPlayerData().getSkillLevel(inv.selected.getSkill());
            ArrayList<String> lore = new ArrayList<String>();
            boolean unlocked = inv.selected.getUnlockLevel() <= inv.getPlayerData().getLevel();
            for (String str : this.getLore()) {
                if (str.startsWith("{unlocked}") && !unlocked || str.startsWith("{locked}") && unlocked || str.startsWith("{max_level}") && (!inv.selected.hasMaxLevel() || inv.selected.getMaxLevel() > inv.getPlayerData().getSkillLevel(inv.selected.getSkill()))) continue;
                if (str.contains("{lore}")) {
                    for (String loreLine : inv.selected.calculateLore(inv.getPlayerData())) {
                        lore.add(ChatColor.GRAY + loreLine);
                    }
                    continue;
                }
                lore.add(holders.apply((OfflinePlayer)inv.getPlayer(), str));
            }
            meta.setDisplayName(MMOCore.plugin.placeholderParser.parse((OfflinePlayer)inv.getPlayer(), this.getName().replace("{skill}", inv.selected.getSkill().getName()).replace("{roman}", MMOCoreUtils.intToRoman(skillLevel)).replace("{level}", "" + skillLevel)));
            meta.addItemFlags(ItemFlag.values());
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public Placeholders getPlaceholders(SkillViewerInventory inv, int n) {
            Placeholders holders = new Placeholders();
            holders.register("selected", inv.selected.getSkill().getName());
            holders.register("skill", inv.selected.getSkill().getName());
            holders.register("unlock", "" + inv.selected.getUnlockLevel());
            holders.register("level", "" + inv.getPlayerData().getSkillLevel(inv.selected.getSkill()));
            return holders;
        }
    }

    public class SkillViewerInventory
    extends GeneratedInventory {
        private final List<ClassSkill> skills;
        private final List<Integer> skillSlots;
        private final List<Integer> slotSlots;
        private ClassSkill selected;
        private int page;

        public SkillViewerInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
            this.page = 0;
            this.skills = playerData.getProfess().getSkills().stream().filter(skill -> playerData.hasUnlocked((Unlockable)skill)).sorted(Comparator.comparingInt(ClassSkill::getUnlockLevel)).collect(Collectors.toList());
            this.skillSlots = this.getEditable().getByFunction("skill").getSlots();
            Validate.notNull((Object)this.getEditable().getByFunction("slot"), (String)"Your skill GUI config file is out-of-date, please regenerate it.");
            this.slotSlots = this.getEditable().getByFunction("slot").getSlots();
            this.selected = this.skills.get(this.page * this.skillSlots.size());
        }

        @Override
        public String calculateName() {
            return SkillList.this.getName().replace("{skill}", this.selected.getSkill().getName());
        }

        @Override
        public void open() {
            super.open();
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("skill")) {
                int index = this.skillSlots.size() * this.page + this.skillSlots.indexOf(context.getSlot());
                this.player.playSound(this.player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 2.0f);
                this.selected = this.skills.get(index);
                this.open();
                return;
            }
            if (item.getFunction().equals("reallocation")) {
                int spent = this.getPlayerData().countSkillPointsSpent();
                if (spent < 1) {
                    ConfigMessage.fromKey("no-skill-points-spent", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                if (this.playerData.getSkillReallocationPoints() < 1) {
                    ConfigMessage.fromKey("not-skill-reallocation-point", new Object[0]).send(this.player);
                    MMOCore.plugin.soundManager.getSound(SoundEvent.NOT_ENOUGH_POINTS).playTo(this.getPlayer());
                    return;
                }
                for (ClassSkill skill : this.playerData.getProfess().getSkills()) {
                    this.playerData.setSkillLevel(skill.getSkill(), 1);
                }
                this.playerData.giveSkillPoints(spent);
                this.playerData.setSkillReallocationPoints(this.playerData.getSkillReallocationPoints() - 1);
                ConfigMessage.fromKey("skill-points-reallocated", "points", "" + this.playerData.getSkillPoints()).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.RESET_SKILLS).playTo(this.getPlayer());
                this.open();
            }
            if (item.getFunction().equals("previous")) {
                this.player.playSound(this.player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 2.0f);
                --this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("next")) {
                this.player.playSound(this.player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 2.0f);
                ++this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("slot")) {
                int index = this.slotSlots.indexOf(context.getSlot()) + 1;
                SkillSlot skillSlot = this.playerData.getProfess().getSkillSlot(index);
                if (context.getClickType() == ClickType.SHIFT_LEFT) {
                    if (this.playerData.hasSkillBound(index)) {
                        this.selected = this.playerData.getBoundSkill(index);
                    }
                    return;
                }
                if (context.getClickType() == ClickType.RIGHT) {
                    if (!this.playerData.hasSkillBound(index)) {
                        ConfigMessage.fromKey("no-skill-bound", new Object[0]).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                        return;
                    }
                    if (!this.playerData.getProfess().getSkillSlot(index).canManuallyBind()) {
                        ConfigMessage.fromKey("cant-manually-bind", new Object[0]).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                        return;
                    }
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 2.0f);
                    this.playerData.unbindSkill(index);
                    this.open();
                    return;
                }
                if (this.selected.isPermanent()) {
                    ConfigMessage.fromKey("skill-cannot-be-bound", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (!this.playerData.hasUnlockedLevel(this.selected)) {
                    ConfigMessage.fromKey("skill-level-not-met", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (!skillSlot.canManuallyBind()) {
                    ConfigMessage.fromKey("cant-manually-bind", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (!skillSlot.acceptsSkill(this.selected)) {
                    ConfigMessage.fromKey("not-compatible-skill", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 2.0f);
                this.playerData.bindSkill(index, this.selected);
                this.open();
                return;
            }
            if (item.getFunction().equals("upgrade")) {
                int shiftCost = ((UpgradeItem)item).shiftCost;
                if (!this.playerData.hasUnlockedLevel(this.selected)) {
                    ConfigMessage.fromKey("skill-level-not-met", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (!this.selected.isUpgradable()) {
                    ConfigMessage.fromKey("cannot-upgrade-skill", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (this.playerData.getSkillPoints() < 1) {
                    ConfigMessage.fromKey("not-enough-skill-points", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (this.selected.hasMaxLevel() && this.playerData.getSkillLevel(this.selected.getSkill()) >= this.selected.getMaxLevel()) {
                    ConfigMessage.fromKey("skill-max-level-hit", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                    return;
                }
                if (context.getClickType().isShiftClick()) {
                    if (this.playerData.getSkillPoints() < shiftCost) {
                        ConfigMessage.fromKey("not-enough-skill-points-shift", "shift_points", "" + shiftCost).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
                        return;
                    }
                    this.playerData.giveSkillPoints(-shiftCost);
                    this.playerData.setSkillLevel(this.selected.getSkill(), this.playerData.getSkillLevel(this.selected.getSkill()) + shiftCost);
                } else {
                    this.playerData.giveSkillPoints(-1);
                    this.playerData.setSkillLevel(this.selected.getSkill(), this.playerData.getSkillLevel(this.selected.getSkill()) + 1);
                }
                ConfigMessage.fromKey("upgrade-skill", "skill", this.selected.getSkill().getName(), "level", "" + this.playerData.getSkillLevel(this.selected.getSkill())).send(this.player);
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
                this.open();
            }
        }
    }
}

