/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.manager.StatManager;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.attribute.PlayerAttribute;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.experience.Booster;
import net.Indyuce.mmocore.experience.Profession;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.party.AbstractParty;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public class PlayerStats
extends EditableInventory {
    public PlayerStats() {
        super("player-stats");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("boost")) {
            return new BoostItem(config);
        }
        if (function.equals("boost-next")) {
            return new SimplePlaceholderItem<PlayerStatsInventory>(config){

                @Override
                public boolean hasDifferentDisplay() {
                    return true;
                }

                @Override
                public boolean canDisplay(PlayerStatsInventory inv) {
                    InventoryItem boost = inv.getByFunction("boost");
                    return boost != null && inv.boostOffset + boost.getSlots().size() < MMOCore.plugin.boosterManager.getActive().size();
                }
            };
        }
        if (function.equals("boost-previous")) {
            return new SimplePlaceholderItem<PlayerStatsInventory>(config){

                @Override
                public boolean canDisplay(PlayerStatsInventory inv) {
                    return inv.boostOffset > 0;
                }
            };
        }
        if (function.equals("party")) {
            return new PartyMoraleItem(config);
        }
        if (function.startsWith("profession_")) {
            String id = function.substring("profession_".length()).toLowerCase();
            Validate.isTrue((boolean)MMOCore.plugin.professionManager.has(id));
            final Profession profession = MMOCore.plugin.professionManager.get(id);
            return new InventoryItem<PlayerStatsInventory>(config){

                @Override
                public boolean hasDifferentDisplay() {
                    return true;
                }

                @Override
                public Placeholders getPlaceholders(PlayerStatsInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    net.Indyuce.mmocore.api.player.stats.PlayerStats stats = inv.target.getStats();
                    double ratio = inv.target.getCollectionSkills().getExperience(profession) / (double)inv.target.getCollectionSkills().getLevelUpExperience(profession);
                    String bar = "" + ChatColor.BOLD;
                    int chars = (int)(ratio * 20.0);
                    for (int j = 0; j < 20; ++j) {
                        bar = bar + (j == chars ? "" + ChatColor.WHITE + ChatColor.BOLD : "") + "|";
                    }
                    holders.register("progress", bar);
                    holders.register("level", String.valueOf(inv.target.getCollectionSkills().getLevel(profession)));
                    holders.register("xp", inv.target.getCollectionSkills().getExperience(profession));
                    holders.register("percent", decimal.format(ratio * 100.0));
                    return holders;
                }
            };
        }
        if (function.equals("profile")) {
            return new PlayerProfileItem(config);
        }
        if (function.equals("stats")) {
            return new InventoryItem<PlayerStatsInventory>(config){

                @Override
                public boolean hasDifferentDisplay() {
                    return true;
                }

                @Override
                public Placeholders getPlaceholders(final PlayerStatsInventory inv, int n) {
                    return new Placeholders(){
                        final net.Indyuce.mmocore.api.player.stats.PlayerStats stats;
                        {
                            this.stats = inv.target.getStats();
                        }

                        @Override
                        @Nullable
                        public String getPlaceholder(String holder) {
                            if (holder.endsWith("_base")) {
                                String stat = UtilityMethods.enumName((String)holder.substring(0, holder.length() - 5));
                                return StatManager.format((String)stat, (double)this.stats.getBase(stat));
                            }
                            if (holder.endsWith("_extra")) {
                                String stat = UtilityMethods.enumName((String)holder.substring(0, holder.length() - 6));
                                return StatManager.format((String)stat, (double)(this.stats.getStat(stat) - this.stats.getBase(stat)));
                            }
                            if (holder.startsWith("attribute_")) {
                                PlayerAttribute attr = MMOCore.plugin.attributeManager.get(holder.substring(10).replace("_", "-").toLowerCase());
                                return String.valueOf(inv.target.getAttributes().getAttribute(attr));
                            }
                            String stat = UtilityMethods.enumName((String)holder);
                            return StatManager.format((String)stat, (double)this.stats.getStat(stat));
                        }
                    };
                }
            };
        }
        return new SimplePlaceholderItem(config);
    }

    public PlayerStatsInventory newInventory(PlayerData invTarget, PlayerData opening) {
        return new PlayerStatsInventory(invTarget, opening, this);
    }

    public PlayerStatsInventory newInventory(PlayerData player) {
        return new PlayerStatsInventory(player, player, this);
    }

    private ItemStack amount(ItemStack item, int amount) {
        item.setAmount(amount);
        return item;
    }

    public class BoostItem
    extends SimplePlaceholderItem<PlayerStatsInventory> {
        private final InventoryItem noBoost;
        private final InventoryItem mainLevel;
        private final InventoryItem profession;

        public BoostItem(ConfigurationSection config) {
            super(config);
            ConfigurationSection noBoost = config.getConfigurationSection("no-boost");
            Validate.notNull((Object)noBoost, (String)"Could not load 'no-boost' config");
            this.noBoost = new SimplePlaceholderItem(noBoost);
            ConfigurationSection mainLevel = config.getConfigurationSection("main-level");
            Validate.notNull((Object)mainLevel, (String)"Could not load 'main-level' config");
            this.mainLevel = new InventoryItem<PlayerStatsInventory>(mainLevel){

                @Override
                public boolean hasDifferentDisplay() {
                    return true;
                }

                @Override
                public Placeholders getPlaceholders(PlayerStatsInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    Booster boost = MMOCore.plugin.boosterManager.get(inv.boostOffset + n);
                    holders.register("author", boost.hasAuthor() ? boost.getAuthor() : "Server");
                    holders.register("value", (int)(boost.getExtra() * 100.0));
                    holders.register("left", boost.isTimedOut() ? ConfigMessage.fromKey("booster-expired", new Object[0]).asLine() : new DelayFormat(2).format(boost.getLeft()));
                    return holders;
                }
            };
            ConfigurationSection profession = config.getConfigurationSection("profession");
            Validate.notNull((Object)profession, (String)"Could not load 'profession' config");
            this.profession = new InventoryItem<PlayerStatsInventory>(profession){

                @Override
                public boolean hasDifferentDisplay() {
                    return true;
                }

                @Override
                public Placeholders getPlaceholders(PlayerStatsInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    Booster boost = MMOCore.plugin.boosterManager.get(inv.boostOffset + n);
                    holders.register("author", boost.hasAuthor() ? boost.getAuthor() : "Server");
                    holders.register("profession", boost.getProfession().getName());
                    holders.register("value", (int)(boost.getExtra() * 100.0));
                    holders.register("left", boost.isTimedOut() ? ConfigMessage.fromKey("booster-expired", new Object[0]).asLine() : new DelayFormat(2).format(boost.getLeft()));
                    return holders;
                }
            };
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(PlayerStatsInventory inv, int n) {
            int offset = inv.boostOffset;
            if (n + offset >= MMOCore.plugin.boosterManager.getActive().size()) {
                return this.noBoost.display(inv, n);
            }
            Booster boost = MMOCore.plugin.boosterManager.get(inv.boostOffset + n);
            return PlayerStats.this.amount(boost.hasProfession() ? this.profession.display(inv, n) : this.mainLevel.display(inv, n), n + offset + 1);
        }
    }

    public static class PartyMoraleItem
    extends InventoryItem<PlayerStatsInventory> {
        public PartyMoraleItem(ConfigurationSection config) {
            super(config);
        }

        @Override
        public Placeholders getPlaceholders(PlayerStatsInventory inv, int n) {
            Placeholders holders = new Placeholders();
            int count = inv.target.getParty().getOnlineMembers().size();
            holders.register("count", String.valueOf(count));
            for (StatModifier buff : MMOCore.plugin.partyManager.getBonuses()) {
                holders.register("buff_" + buff.getStat().toLowerCase(), buff.multiply((double)(count - 1)).toString());
            }
            return holders;
        }

        @Override
        public boolean canDisplay(PlayerStatsInventory inv) {
            AbstractParty party = inv.target.getParty();
            return party != null && party.getOnlineMembers().size() > 1;
        }
    }

    public static class PlayerProfileItem
    extends InventoryItem<PlayerStatsInventory> {
        public PlayerProfileItem(ConfigurationSection config) {
            super(config);
        }

        @Override
        public ItemStack display(PlayerStatsInventory inv, int n) {
            ItemStack disp = super.display(inv, n);
            if (disp.getType() == Material.PLAYER_HEAD) {
                SkullMeta meta = (SkullMeta)disp.getItemMeta();
                inv.asyncUpdate(this, n, disp, current -> {
                    meta.setOwningPlayer((OfflinePlayer)inv.target.getPlayer());
                    current.setItemMeta((ItemMeta)meta);
                });
            }
            return disp;
        }

        @Override
        public Placeholders getPlaceholders(PlayerStatsInventory inv, int n) {
            PlayerData data = inv.target;
            Placeholders holders = new Placeholders();
            int nextLevelExp = inv.target.getLevelUpExperience();
            double ratio = data.getExperience() / (double)nextLevelExp;
            StringBuilder bar = new StringBuilder("" + ChatColor.BOLD);
            int chars = (int)(ratio * 20.0);
            for (int j = 0; j < 20; ++j) {
                bar.append(j == chars ? "" + ChatColor.WHITE + ChatColor.BOLD : "").append("|");
            }
            holders.register("percent", decimal.format(ratio * 100.0));
            holders.register("exp", MythicLib.plugin.getMMOConfig().decimal.format(data.getExperience()));
            holders.register("level", "" + data.getLevel());
            holders.register("class_points", "" + data.getClassPoints());
            holders.register("skill_points", "" + data.getSkillPoints());
            holders.register("attribute_points", "" + data.getAttributePoints());
            holders.register("progress", bar.toString());
            holders.register("next_level", "" + nextLevelExp);
            if (data.isOnline()) {
                holders.register("player", "" + data.getPlayer().getName());
            }
            holders.register("class", "" + data.getProfess().getName());
            return holders;
        }
    }

    public class PlayerStatsInventory
    extends GeneratedInventory {
        private final PlayerData target;
        private int boostOffset;

        public PlayerStatsInventory(PlayerData invTarget, PlayerData opening, EditableInventory inv) {
            super(opening, inv);
            this.target = invTarget;
        }

        @Override
        public String calculateName() {
            return PlayerStats.this.getName();
        }

        @Override
        public void whenClicked(InventoryClickContext event, InventoryItem item) {
            if (item.hasFunction()) {
                if (item.getFunction().equals("boost-next")) {
                    ++this.boostOffset;
                    this.open();
                } else if (item.getFunction().equals("boost-previous")) {
                    --this.boostOffset;
                    this.open();
                }
            }
        }
    }
}

