/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import io.lumine.mythic.lib.UtilityMethods;
import javax.annotation.Nullable;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.event.PlayerChangeClassEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.profess.PlayerClass;
import net.Indyuce.mmocore.api.player.profess.SavedClassInformation;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.PluginInventory;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ClassConfirmation
extends EditableInventory {
    private final PlayerClass playerClass;

    public ClassConfirmation(PlayerClass playerClass, boolean isDefault) {
        super("class-confirm-" + (isDefault ? "default" : UtilityMethods.ymlName((String)playerClass.getId())));
        this.playerClass = playerClass;
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        return function.equalsIgnoreCase("yes") ? new YesItem(config) : new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data, PluginInventory last, boolean setClass) {
        return this.newInventory(data, last, setClass, null);
    }

    public GeneratedInventory newInventory(PlayerData data, PluginInventory last, boolean setClass, @Nullable Runnable profileRunnable) {
        return new ClassConfirmationInventory(data, this, this.playerClass, last, setClass, profileRunnable);
    }

    public class YesItem
    extends SimplePlaceholderItem<ClassConfirmationInventory> {
        private final InventoryItem unlocked;
        private final InventoryItem locked;

        public YesItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
            Validate.isTrue((boolean)config.contains("unlocked"), (String)"Could not load 'unlocked' config");
            Validate.isTrue((boolean)config.contains("locked"), (String)"Could not load 'locked' config");
            this.unlocked = new UnlockedItem(config.getConfigurationSection("unlocked"));
            this.locked = new InventoryItem<ClassConfirmationInventory>(config.getConfigurationSection("locked")){

                @Override
                public Placeholders getPlaceholders(ClassConfirmationInventory inv, int n) {
                    Placeholders holders = new Placeholders();
                    holders.register("class", inv.profess.getName());
                    return holders;
                }
            };
        }

        @Override
        public ItemStack display(ClassConfirmationInventory inv, int n) {
            return inv.getPlayerData().hasSavedClass(inv.profess) ? this.unlocked.display(inv, n) : this.locked.display(inv, n);
        }
    }

    public class ClassConfirmationInventory
    extends GeneratedInventory {
        private final PlayerClass profess;
        private final PluginInventory last;
        private final boolean subclass;
        @Nullable
        private final Runnable profileRunnable;
        private boolean canClose;

        public ClassConfirmationInventory(PlayerData playerData, EditableInventory editable, PlayerClass profess, PluginInventory last, @Nullable boolean subclass, Runnable profileRunnable) {
            super(playerData, editable);
            this.profess = profess;
            this.last = last;
            this.subclass = subclass;
            this.profileRunnable = profileRunnable;
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("back")) {
                this.canClose = true;
                this.last.open();
            } else if (item.getFunction().equals("yes")) {
                PlayerChangeClassEvent called = new PlayerChangeClassEvent(this.playerData, this.profess);
                Bukkit.getPluginManager().callEvent((Event)called);
                if (called.isCancelled()) {
                    return;
                }
                this.canClose = true;
                this.playerData.giveClassPoints(-1);
                if (this.subclass) {
                    this.playerData.setClass(this.profess);
                } else {
                    (this.playerData.hasSavedClass(this.profess) ? this.playerData.getClassInfo(this.profess) : new SavedClassInformation(MMOCore.plugin.playerDataManager.getDefaultData())).load(this.profess, this.playerData);
                }
                ConfigMessage.fromKey("class-select", "class", this.profess.getName()).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.SELECT_CLASS).playTo(this.player);
                this.player.closeInventory();
                if (this.profileRunnable != null) {
                    this.profileRunnable.run();
                }
            }
        }

        @Override
        public void open() {
            this.canClose = false;
            super.open();
        }

        @Override
        public void whenClosed(InventoryCloseEvent event) {
            if (this.profileRunnable != null && !this.canClose) {
                Bukkit.getScheduler().runTaskLater((Plugin)MMOCore.plugin, () -> this.open(), 40L);
            }
        }

        @Override
        public String calculateName() {
            return ClassConfirmation.this.getName().replace("{class}", this.profess.getName());
        }
    }

    public class UnlockedItem
    extends InventoryItem<ClassConfirmationInventory> {
        public UnlockedItem(ConfigurationSection config) {
            super(config);
        }

        @Override
        public Placeholders getPlaceholders(ClassConfirmationInventory inv, int n) {
            PlayerClass profess = inv.profess;
            PlayerData info = inv.subclass ? inv.getPlayerData() : inv.getPlayerData().getClassInfo(profess);
            Placeholders holders = new Placeholders();
            double nextLevelExp = inv.getPlayerData().getLevelUpExperience();
            double ratio = info.getExperience() / nextLevelExp;
            StringBuilder bar = new StringBuilder("" + ChatColor.BOLD);
            int chars = (int)(ratio * 20.0);
            for (int j = 0; j < 20; ++j) {
                bar.append(j == chars ? "" + ChatColor.WHITE + ChatColor.BOLD : "").append("|");
            }
            holders.register("percent", decimal.format(ratio * 100.0));
            holders.register("progress", bar.toString());
            holders.register("class", profess.getName());
            holders.register("unlocked_skills", info.mapSkillLevels().size());
            holders.register("class_skills", profess.getSkills().size());
            holders.register("next_level", "" + nextLevelExp);
            holders.register("level", info.getLevel());
            holders.register("exp", info.getExperience());
            holders.register("skill_points", info.getSkillPoints());
            return holders;
        }
    }
}

