/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience.source;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;

public class RideExperienceSource
extends SpecificExperienceSource<EntityType> {
    private final EntityType type;

    public RideExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        if (!config.contains("type")) {
            this.type = null;
        } else {
            String str = config.getString("type").toUpperCase().replace("-", "_");
            Validate.isTrue((boolean)Arrays.stream(EntityType.values()).map(Objects::toString).collect(Collectors.toList()).contains(str), (String)"The type must correspond to an entity that exist in the game.");
            this.type = EntityType.valueOf((String)str);
        }
    }

    @Override
    public ExperienceSourceManager<RideExperienceSource> newManager() {
        return new Manager();
    }

    @Override
    public boolean matchesParameter(PlayerData player, EntityType obj) {
        if (this.type == null) {
            return true;
        }
        return this.type.equals((Object)obj);
    }

    private static class Manager
    extends ExperienceSourceManager<RideExperienceSource> {
        private Manager() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onRide(PlayerMoveEvent event) {
            if (!event.getPlayer().isInsideVehicle()) {
                return;
            }
            double deltax = event.getTo().getBlockX() - event.getFrom().getBlockX();
            double deltay = event.getTo().getBlockY() - event.getFrom().getBlockY();
            double deltaz = event.getTo().getBlockZ() - event.getFrom().getBlockZ();
            if (deltax != 0.0 || deltay != 0.0 || deltaz != 0.0) {
                if (!UtilityMethods.isRealPlayer((Entity)event.getPlayer())) {
                    return;
                }
                PlayerData playerData = PlayerData.get((OfflinePlayer)event.getPlayer());
                Entity vehicle = event.getPlayer().getVehicle();
                for (RideExperienceSource source : this.getSources()) {
                    if (!source.matchesParameter(playerData, vehicle.getType())) continue;
                    source.giveExperience(playerData, event.getFrom().distance(event.getTo()), null);
                }
            }
        }
    }
}

