/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience.source;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.EXPSource;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.ExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class EnchantItemExperienceSource
extends ExperienceSource<Void> {
    private final List<Enchantment> enchants = new ArrayList<Enchantment>();

    public EnchantItemExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser);
        if (config.contains("enchant")) {
            for (String key : config.getString("enchant").split(",")) {
                this.enchants.add(MythicLib.plugin.getVersion().getWrapper().getEnchantmentFromString(key.toLowerCase().replace("-", "_")));
            }
        }
    }

    @Override
    public boolean matchesParameter(PlayerData player, Void v) {
        return true;
    }

    @Override
    public ExperienceSourceManager<EnchantItemExperienceSource> newManager() {
        return new Manager();
    }

    private static class Manager
    extends ExperienceSourceManager<EnchantItemExperienceSource> {
        private Manager() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void a(EnchantItemEvent event) {
            PlayerData player = PlayerData.get((OfflinePlayer)event.getEnchanter());
            for (EnchantItemExperienceSource source : this.getSources()) {
                if (!source.matches(player, null)) continue;
                HashMap applicableEnchants = new HashMap(event.getEnchantsToAdd());
                if (!source.enchants.isEmpty()) {
                    applicableEnchants.keySet().removeIf(enchantment -> !source.enchants.contains(enchantment));
                }
                if (applicableEnchants.isEmpty()) continue;
                double exp = 0.0;
                for (Map.Entry entry : applicableEnchants.entrySet()) {
                    exp += MMOCore.plugin.enchantManager.getBaseExperience((Enchantment)entry.getKey()) * (double)((Integer)entry.getValue()).intValue();
                }
                source.getDispenser().giveExperience(player, exp, event.getEnchantBlock().getLocation(), EXPSource.SOURCE);
            }
        }
    }
}

