/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience.source;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class EatExperienceSource
extends SpecificExperienceSource<ItemStack> {
    private final Material type;

    public EatExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        if (!config.contains("type")) {
            this.type = null;
        } else {
            Material material = Material.valueOf((String)config.getString("type").toUpperCase().replace("-", "_"));
            Validate.isTrue((material != null ? 1 : 0) != 0, (String)"You must precise a valid material!");
            this.type = material;
        }
    }

    @Override
    public ExperienceSourceManager<EatExperienceSource> newManager() {
        return new Manager();
    }

    @Override
    public boolean matchesParameter(PlayerData player, ItemStack obj) {
        if (this.type == null) {
            return true;
        }
        return this.type.equals((Object)obj.getType());
    }

    private static class Manager
    extends ExperienceSourceManager<EatExperienceSource> {
        private Manager() {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void a(PlayerItemConsumeEvent e) {
            if (!e.getPlayer().hasMetadata("NPC")) {
                PlayerData playerData = PlayerData.get((OfflinePlayer)e.getPlayer());
                for (EatExperienceSource source : this.getSources()) {
                    if (!source.matchesParameter(playerData, e.getItem())) continue;
                    source.giveExperience(playerData, 1.0, null);
                }
            }
        }
    }
}

