/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience.source;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.util.Lazy;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DamageTakenExperienceSource
extends SpecificExperienceSource<EntityDamageEvent.DamageCause> {
    private final EntityDamageEvent.DamageCause cause;

    public DamageTakenExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        if (!config.contains("type")) {
            this.cause = null;
        } else {
            String str = config.getString("type").toUpperCase().replace("-", "_");
            Validate.isTrue((boolean)Arrays.stream(EntityDamageEvent.DamageCause.values()).map(Objects::toString).collect(Collectors.toList()).contains(str), (String)"Cause not allowed. Go check at all the Damage Causes in EntityDamageEvent.DamageCause enum.");
            this.cause = EntityDamageEvent.DamageCause.valueOf((String)str);
        }
    }

    @Override
    public ExperienceSourceManager<DamageTakenExperienceSource> newManager() {
        return new Manager();
    }

    @Override
    public boolean matchesParameter(PlayerData player, EntityDamageEvent.DamageCause damageCause) {
        if (player.getPlayer().isDead()) {
            return false;
        }
        return this.cause == null || damageCause.equals((Object)this.cause);
    }

    private static class Manager
    extends ExperienceSourceManager<DamageTakenExperienceSource> {
        private Manager() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onDamageTaken(final EntityDamageEvent event) {
            if (!UtilityMethods.isRealPlayer((Entity)event.getEntity())) {
                return;
            }
            final PlayerData playerData = PlayerData.get((OfflinePlayer)((Player)event.getEntity()));
            final Lazy effectiveDamage = Lazy.of(() -> {
                double eventDamage = event.getDamage();
                double maxHealth = ((Player)event.getEntity()).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                return Math.min(eventDamage, maxHealth);
            });
            new BukkitRunnable(){

                public void run() {
                    for (DamageTakenExperienceSource source : this.getSources()) {
                        if (!source.matchesParameter(playerData, event.getCause())) continue;
                        source.giveExperience(playerData, (Double)effectiveDamage.get(), null);
                    }
                }
            }.runTaskLater((Plugin)MMOCore.plugin, 2L);
        }
    }
}

