/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience.source;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import net.Indyuce.mmocore.experience.source.type.SpecificExperienceSource;
import net.Indyuce.mmocore.manager.profession.ExperienceSourceManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;

public class ClimbExperienceSource
extends SpecificExperienceSource<Material> {
    private final Material type;

    public ClimbExperienceSource(ExperienceDispenser dispenser, MMOLineConfig config) {
        super(dispenser, config);
        if (!config.contains("type")) {
            this.type = null;
        } else {
            String str = config.getString("type").toUpperCase().replace("-", "_");
            Validate.isTrue((str.equals("LADDER") || str.equals("VINE") || str.equals("TWISTING_VINES") || str.equals("WEEPING_VINES") ? 1 : 0) != 0, (String)"ClimbExperienceSource problem: The type must be ladder, vine, twisting-vines or weeping-vines");
            this.type = Material.valueOf((String)str);
        }
    }

    @Override
    public ExperienceSourceManager<ClimbExperienceSource> newManager() {
        return new Manager();
    }

    @Override
    public boolean matchesParameter(PlayerData player, Material material) {
        if (this.type == null) {
            return material.equals((Object)Material.LADDER) || material.equals((Object)Material.VINE) || material.equals((Object)Material.WEEPING_VINES) || material.equals((Object)Material.TWISTING_VINES) || material.equals((Object)Material.WEEPING_VINES_PLANT) || material.equals((Object)Material.TWISTING_VINES_PLANT);
        }
        if (this.type.equals((Object)Material.WEEPING_VINES)) {
            return material.equals((Object)Material.WEEPING_VINES) || material.equals((Object)Material.WEEPING_VINES_PLANT);
        }
        if (this.type.equals((Object)Material.TWISTING_VINES)) {
            return material.equals((Object)Material.TWISTING_VINES) || material.equals((Object)Material.TWISTING_VINES_PLANT);
        }
        return material.equals((Object)this.type);
    }

    private static class Manager
    extends ExperienceSourceManager<ClimbExperienceSource> {
        private Manager() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onClimb(PlayerMoveEvent e) {
            double delta = e.getTo().getBlockY() - e.getFrom().getBlockY();
            if (delta > 0.0) {
                if (e.getPlayer().hasMetadata("NPC")) {
                    return;
                }
                PlayerData playerData = PlayerData.get((OfflinePlayer)e.getPlayer());
                for (ClimbExperienceSource source : this.getSources()) {
                    if (!source.matchesParameter(playerData, e.getFrom().getBlock().getType())) continue;
                    source.giveExperience(playerData, delta, null);
                }
            }
        }
    }
}

