/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.experience;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.util.PostLoadAction;
import io.lumine.mythic.lib.util.PreloadedObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.math.formula.LinearValue;
import net.Indyuce.mmocore.experience.EXPSource;
import net.Indyuce.mmocore.experience.ExpCurve;
import net.Indyuce.mmocore.experience.ExperienceObject;
import net.Indyuce.mmocore.experience.droptable.ExperienceTable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Profession
implements ExperienceObject,
PreloadedObject {
    private final String id;
    private final String name;
    private final int maxLevel;
    private final Map<ProfessionOption, Boolean> options = new HashMap<ProfessionOption, Boolean>();
    private final ExpCurve expCurve;
    private final ExperienceTable expTable;
    private final LinearValue experience;
    private final PostLoadAction postLoadAction = new PostLoadAction(config -> MMOCore.plugin.professionManager.loadProfessionConfigurations(this, (ConfigurationSection)config));

    public Profession(String id, ConfigurationSection config2) {
        this.postLoadAction.cacheConfig(config2);
        this.id = id.toLowerCase().replace("_", "-").replace(" ", "-");
        this.name = config2.getString("name");
        Validate.notNull((Object)this.name, (String)"Could not load name");
        this.expCurve = config2.contains("exp-curve") ? MMOCore.plugin.experience.getCurveOrThrow(config2.get("exp-curve").toString().toLowerCase().replace("_", "-").replace(" ", "-")) : ExpCurve.DEFAULT;
        this.experience = new LinearValue(config2.getConfigurationSection("experience"));
        ExperienceTable expTable = null;
        if (config2.contains("exp-table")) {
            try {
                expTable = MMOCore.plugin.experience.loadExperienceTable(config2.get("exp-table"));
            }
            catch (RuntimeException exception) {
                MMOCore.plugin.getLogger().log(Level.WARNING, "Could not load exp table from profession '" + id + "': " + exception.getMessage());
            }
        }
        this.expTable = expTable;
        if (config2.contains("options")) {
            for (String key : config2.getConfigurationSection("options").getKeys(false)) {
                try {
                    ProfessionOption option = ProfessionOption.valueOf(key.toUpperCase().replace("-", "_").replace(" ", "_"));
                    this.options.put(option, config2.getBoolean("options." + key));
                }
                catch (IllegalArgumentException exception) {
                    MMOCore.plugin.getLogger().log(Level.WARNING, "Could not load option '" + key + "' from profession '" + id + "': " + exception.getMessage());
                }
            }
        }
        this.maxLevel = config2.getInt("max-level");
        if (config2.contains("exp-sources")) {
            for (String key : config2.getStringList("exp-sources")) {
                try {
                    MMOCore.plugin.experience.registerSource(MMOCore.plugin.loadManager.loadExperienceSource(new MMOLineConfig(key), this));
                }
                catch (IllegalArgumentException exception) {
                    MMOCore.plugin.getLogger().log(Level.WARNING, "Could not register exp source '" + key + "' from profession '" + id + "': " + exception.getMessage());
                }
            }
        }
    }

    @NotNull
    public PostLoadAction getPostLoadAction() {
        return this.postLoadAction;
    }

    public boolean getOption(ProfessionOption option) {
        return this.options.getOrDefault((Object)option, option.getDefault());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return "profession_" + this.getId();
    }

    @Override
    public ExpCurve getExpCurve() {
        return this.expCurve;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean hasMaxLevel() {
        return this.maxLevel > 0;
    }

    public LinearValue getExperience() {
        return this.experience;
    }

    @Override
    public boolean hasExperienceTable() {
        return this.expTable != null;
    }

    @Override
    @NotNull
    public ExperienceTable getExperienceTable() {
        return Objects.requireNonNull(this.expTable, "Profession has no exp table");
    }

    @Override
    public void giveExperience(@NotNull PlayerData playerData, double experience, @Nullable Location hologramLocation, @NotNull EXPSource source) {
        playerData.getCollectionSkills().giveExperience(this, experience, EXPSource.SOURCE, hologramLocation, true);
    }

    @Override
    public boolean shouldHandle(PlayerData playerData) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profession that = (Profession)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum ProfessionOption {
        EXP_HOLOGRAMS(true);

        private final boolean def;

        private ProfessionOption(boolean def) {
            this.def = def;
        }

        public boolean getDefault() {
            return this.def;
        }
    }
}

