/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.comp.vault;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.quest.trigger.Trigger;
import net.Indyuce.mmocore.api.util.math.formula.RandomAmount;
import org.bukkit.OfflinePlayer;

public class MoneyTrigger
extends Trigger {
    private final RandomAmount amount;
    private final Operation operation;

    public MoneyTrigger(MMOLineConfig config) {
        super(config);
        config.validate(new String[]{"amount"});
        this.amount = new RandomAmount(config.getString("amount"));
        this.operation = config.contains("operation") ? Operation.valueOf(config.getString("operation").toUpperCase()) : Operation.GIVE;
    }

    @Override
    public void apply(PlayerData player) {
        if (!MMOCore.plugin.economy.isValid() || !player.isOnline()) {
            return;
        }
        if (this.operation == Operation.GIVE) {
            MMOCore.plugin.economy.getEconomy().depositPlayer((OfflinePlayer)player.getPlayer(), this.amount.calculate());
        } else {
            if (this.operation == Operation.SET) {
                throw new IllegalArgumentException("Operation SET is not available for the money trigger.");
            }
            MMOCore.plugin.economy.getEconomy().withdrawPlayer((OfflinePlayer)player.getPlayer(), this.amount.calculate());
        }
    }

    public static enum Operation {
        GIVE,
        SET,
        TAKE;

    }
}

