/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.comp.region.pvpmode;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.session.handler.Handler;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.comp.region.pvpmode.PvPFlagHandler;
import net.Indyuce.mmocore.comp.region.pvpmode.PvPModeHandler;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class PvPModeListener
implements Listener {
    public PvPModeListener() {
        Validate.isTrue((boolean)this.registerHandler(PvPModeHandler.FACTORY), (String)"Could not register WG handler for PvP mode");
        if (MMOCore.plugin.getConfig().getBoolean("pvp_mode.invulnerability.apply_to_pvp_flag")) {
            Validate.isTrue((boolean)this.registerHandler(PvPFlagHandler.FACTORY), (String)"Could not register WG handler for PvP");
        }
    }

    private boolean registerHandler(Handler.Factory<?> factory) {
        return WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler(factory, null);
    }

    @EventHandler(ignoreCancelled=true)
    public void a(EntityDamageByEntityEvent event) {
        if (!UtilityMethods.isRealPlayer((Entity)event.getEntity())) {
            return;
        }
        Player source = UtilityMethods.getPlayerDamager((EntityDamageByEntityEvent)event);
        if (source == null) {
            return;
        }
        Player target = (Player)event.getEntity();
        PlayerData targetData = PlayerData.get((OfflinePlayer)target);
        PlayerData sourceData = PlayerData.get((OfflinePlayer)source);
        int minLevel = MMOCore.plugin.configManager.minCombatLevel;
        if (minLevel > 0) {
            if (targetData.getLevel() < minLevel) {
                event.setCancelled(true);
                if (event.getDamage() > 0.0) {
                    ConfigMessage.fromKey("pvp-mode.cannot-hit.low-level-target", new Object[0]).send(source);
                }
                return;
            }
            if (sourceData.getLevel() < minLevel) {
                event.setCancelled(true);
                if (event.getDamage() > 0.0) {
                    ConfigMessage.fromKey("pvp-mode.cannot-hit.low-level-self", new Object[0]).send(source);
                }
                return;
            }
            int maxLevelDiff = MMOCore.plugin.configManager.maxCombatLevelDifference;
            if (maxLevelDiff > 0 && Math.abs(targetData.getLevel() - sourceData.getLevel()) > maxLevelDiff) {
                event.setCancelled(true);
                if (event.getDamage() > 0.0) {
                    ConfigMessage.fromKey("pvp-mode.cannot-hit.high-level-difference", new Object[0]).send(source);
                }
                return;
            }
        }
        if (targetData.getCombat().isInvulnerable()) {
            if (event.getDamage() > 0.0) {
                long left = targetData.getCombat().getInvulnerableTill() - System.currentTimeMillis();
                ConfigMessage.fromKey("pvp-mode.cannot-hit.invulnerable-target", "left", MythicLib.plugin.getMMOConfig().decimal.format((double)left / 1000.0)).send(source);
            }
            event.setCancelled(true);
            return;
        }
        if (!MMOCore.plugin.configManager.pvpModeInvulnerabilityCanDamage && sourceData.getCombat().isInvulnerable()) {
            if (event.getDamage() > 0.0) {
                long left = sourceData.getCombat().getInvulnerableTill() - System.currentTimeMillis();
                ConfigMessage.fromKey("pvp-mode.cannot-hit.invulnerable-self", "left", MythicLib.plugin.getMMOConfig().decimal.format((double)left / 1000.0)).send(source);
            }
            event.setCancelled(true);
            return;
        }
        if (!MythicLib.plugin.getFlags().isFlagAllowed(target.getLocation(), CustomFlag.PVP_MODE)) {
            return;
        }
        if (!targetData.getCombat().isInPvpMode()) {
            event.setCancelled(true);
            if (event.getDamage() > 0.0) {
                ConfigMessage.fromKey("pvp-mode.cannot-hit.pvp-mode-disabled-target", new Object[0]).send(source);
            }
        } else if (!sourceData.getCombat().isInPvpMode()) {
            event.setCancelled(true);
            if (event.getDamage() > 0.0) {
                ConfigMessage.fromKey("pvp-mode.cannot-hit.pvp-mode-disabled-self", new Object[0]).send(source);
            }
        }
    }
}

