/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.cast;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.rpg.cast.SpecificCommandTreeNode;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.binding.BoundSkillInfo;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FirstCommandTreeNode
extends CommandTreeNode {
    public FirstCommandTreeNode(CommandTreeNode parent) {
        super(parent, "first");
        this.addParameter(Parameter.PLAYER);
        this.addParameter(SpecificCommandTreeNode.INTEGER);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        int slot;
        if (args.length < 3) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[2] + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        try {
            slot = Integer.parseInt(args[3]);
            Validate.isTrue((slot > 0 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            sender.sendMessage(ChatColor.RED + args[3] + " is not a valid integer.");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        List slots = data.getBoundSkills().entrySet().stream().filter(e -> !((BoundSkillInfo)e.getValue()).isPassive()).map(Map.Entry::getKey).sorted(Integer::compare).collect(Collectors.toList());
        if (slot > slots.size()) {
            sender.sendMessage(ChatColor.RED + "Player " + player.getName() + " only has active skills on slots " + slots + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        ClassSkill skill = data.getBoundSkill((Integer)slots.get(slot - 1));
        Validate.notNull((Object)skill, (String)"Internal error: skill is null");
        Validate.isTrue((!skill.getSkill().getTrigger().isPassive() ? 1 : 0) != 0, (String)"Internal error: skill is passive");
        boolean success = skill.toCastable(data).cast(data.getMMOPlayerData()).isSuccessful();
        return success ? CommandTreeNode.CommandResult.SUCCESS : CommandTreeNode.CommandResult.FAILURE;
    }
}

