/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import net.Indyuce.mmocore.util.TriConsumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillTreePointsCommandTreeNode
extends CommandTreeNode {
    BiFunction<PlayerData, String, Integer> get;

    public SkillTreePointsCommandTreeNode(CommandTreeNode parent, TriConsumer<PlayerData, Integer, String> set, TriConsumer<PlayerData, Integer, String> give, BiFunction<PlayerData, String, Integer> get) {
        super(parent, "skill-tree-points");
        this.addChild(new ActionCommandTreeNode(this, "give", give));
        this.addChild(new ActionCommandTreeNode(this, "set", set));
        this.get = get;
    }

    public CommandTreeNode.CommandResult execute(CommandSender commandSender, String[] strings) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public class ActionCommandTreeNode
    extends CommandTreeNode {
        private final TriConsumer<PlayerData, Integer, String> action;

        public ActionCommandTreeNode(CommandTreeNode parent, String id, TriConsumer<PlayerData, Integer, String> action) {
            super(parent, id);
            this.action = action;
            this.addParameter(Parameter.PLAYER);
            this.addParameter(Parameter.AMOUNT);
            this.addParameter(new Parameter("<type>", (explorer, list) -> {
                MMOCore.plugin.skillTreeManager.getAll().forEach(tree -> list.add(tree.getId()));
                list.add("global");
            }));
        }

        public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
            int amount;
            if (args.length < 6) {
                return CommandTreeNode.CommandResult.THROW_USAGE;
            }
            Player player = Bukkit.getPlayer((String)args[3]);
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            try {
                amount = Integer.parseInt(args[4]);
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + args[4] + " is not a valid number.");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            ArrayList<String> list = new ArrayList<String>();
            MMOCore.plugin.skillTreeManager.getAll().forEach(tree -> list.add(tree.getId()));
            list.add("global");
            String id = args[5];
            if (!list.contains(id)) {
                sender.sendMessage("Could not find the type of points " + id + ".");
                return CommandTreeNode.CommandResult.FAILURE;
            }
            PlayerData data = PlayerData.get((OfflinePlayer)player);
            this.action.accept(data, amount, args[5]);
            CommandVerbose.verbose(sender, CommandVerbose.CommandType.SKILL_TREE_POINTS, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + " now has " + ChatColor.GOLD + SkillTreePointsCommandTreeNode.this.get.apply(data, id) + ChatColor.YELLOW + " " + id + " skill tree points.");
            return CommandTreeNode.CommandResult.SUCCESS;
        }
    }
}

