/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import net.Indyuce.mmocore.experience.Profession;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class ResetLevelsCommandTreeNode
extends CommandTreeNode {
    public ResetLevelsCommandTreeNode(CommandTreeNode parent) {
        super(parent, "levels");
        this.addParameter(Parameter.PLAYER);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        if (args.length < 4) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        Player player = Bukkit.getPlayer((String)args[3]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[3] + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        ResetLevelsCommandTreeNode.resetLevels(PlayerData.get((OfflinePlayer)player));
        CommandVerbose.verbose(sender, CommandVerbose.CommandType.RESET, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + "'s levels were successfully reset.");
        return CommandTreeNode.CommandResult.SUCCESS;
    }

    static void resetLevels(@NotNull PlayerData data) {
        data.setLevel(MMOCore.plugin.playerDataManager.getDefaultData().getLevel());
        data.setExperience(0.0);
        data.getProfess().resetAdvancement(data, true);
        for (Profession profession : MMOCore.plugin.professionManager.getAll()) {
            data.getCollectionSkills().setExperience(profession, 0.0);
            data.getCollectionSkills().setLevel(profession, 0);
            profession.resetAdvancement(data, true);
        }
    }
}

