/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.experience.Profession;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoCommandTreeNode
extends CommandTreeNode {
    public InfoCommandTreeNode(CommandTreeNode parent) {
        super(parent, "info");
        this.addParameter(Parameter.PLAYER);
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        if (args.length < 3) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[2] + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerData playerData = PlayerData.get((OfflinePlayer)player);
        sender.sendMessage(ChatColor.YELLOW + "----------------------------------------------------");
        sender.sendMessage(ChatColor.YELLOW + "Class: " + ChatColor.GOLD + playerData.getProfess().getName());
        sender.sendMessage(ChatColor.YELLOW + "Level: " + ChatColor.GOLD + playerData.getLevel());
        sender.sendMessage(ChatColor.YELLOW + "Experience: " + ChatColor.GOLD + MythicLib.plugin.getMMOConfig().decimal.format(playerData.getExperience()) + ChatColor.YELLOW + " / " + ChatColor.GOLD + playerData.getLevelUpExperience());
        sender.sendMessage(ChatColor.YELLOW + "Class Points: " + ChatColor.GOLD + playerData.getClassPoints());
        sender.sendMessage(ChatColor.YELLOW + "Quests: " + ChatColor.GOLD + playerData.getQuestData().getFinishedQuests().size() + ChatColor.YELLOW + " / " + ChatColor.GOLD + MMOCore.plugin.questManager.getAll().size());
        sender.sendMessage(ChatColor.YELLOW + "----------------------------------------------------");
        for (Profession profession : MMOCore.plugin.professionManager.getAll()) {
            sender.sendMessage(ChatColor.YELLOW + profession.getName() + ": Lvl " + ChatColor.GOLD + playerData.getCollectionSkills().getLevel(profession) + ChatColor.YELLOW + " - " + ChatColor.GOLD + playerData.getCollectionSkills().getExperience(profession) + ChatColor.YELLOW + " / " + ChatColor.GOLD + playerData.getCollectionSkills().getLevelUpExperience(profession));
        }
        sender.sendMessage(ChatColor.YELLOW + "----------------------------------------------------");
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

