/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command.rpg.admin;

import io.lumine.mythic.lib.command.api.CommandTreeNode;
import io.lumine.mythic.lib.command.api.Parameter;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.event.PlayerChangeClassEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.player.profess.PlayerClass;
import net.Indyuce.mmocore.api.player.profess.SavedClassInformation;
import net.Indyuce.mmocore.command.api.CommandVerbose;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ClassCommandTreeNode
extends CommandTreeNode {
    public ClassCommandTreeNode(CommandTreeNode parent) {
        super(parent, "class");
        this.addParameter(Parameter.PLAYER);
        this.addParameter(new Parameter("<class>", (explorer, list) -> MMOCore.plugin.classManager.getAll().forEach(profess -> list.add(profess.getId()))));
    }

    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        if (args.length < 4) {
            return CommandTreeNode.CommandResult.THROW_USAGE;
        }
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Could not find the player called " + args[2] + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        String format = args[3].toUpperCase().replace("-", "_");
        if (!MMOCore.plugin.classManager.has(format)) {
            sender.sendMessage(ChatColor.RED + "Could not find class " + format + ".");
            return CommandTreeNode.CommandResult.FAILURE;
        }
        PlayerClass profess = MMOCore.plugin.classManager.get(format);
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        if (data.getProfess().equals(profess)) {
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        PlayerChangeClassEvent called = new PlayerChangeClassEvent(data, profess);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return CommandTreeNode.CommandResult.SUCCESS;
        }
        (data.hasSavedClass(profess) ? data.getClassInfo(profess) : new SavedClassInformation(MMOCore.plugin.playerDataManager.getDefaultData())).load(profess, data);
        if (data.isOnline()) {
            ConfigMessage.fromKey("class-select", "class", profess.getName()).send(data.getPlayer());
            data.getPlayer().playSound(data.getPlayer().getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        }
        CommandVerbose.verbose(sender, CommandVerbose.CommandType.CLASS, ChatColor.GOLD + player.getName() + ChatColor.YELLOW + " is now a " + ChatColor.GOLD + profess.getName() + ChatColor.YELLOW + ".");
        return CommandTreeNode.CommandResult.SUCCESS;
    }
}

