/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.event.MMOCommandEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.RegisteredCommand;
import net.Indyuce.mmocore.command.api.ToggleableCommand;
import net.Indyuce.mmocore.manager.InventoryManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class SkillTreesCommand
extends RegisteredCommand {
    public SkillTreesCommand(ConfigurationSection config) {
        super(config, ToggleableCommand.SKILL_TREES);
    }

    public boolean execute(@NotNull CommandSender sender, String s, String[] args) {
        if (!sender.hasPermission("mmocore.skilltrees")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        PlayerData data = PlayerData.get((OfflinePlayer)player);
        MMOCommandEvent event = new MMOCommandEvent(data, "skilltrees");
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (args.length == 0) {
            if (!MMOCore.plugin.configManager.enableGlobalSkillTreeGUI) {
                sender.sendMessage(ChatColor.RED + "Usage: /skilltrees <skilltree_id>");
                return false;
            }
            if (data.getProfess().getSkillTrees().size() != 0) {
                InventoryManager.TREE_VIEW.newInventory(data).open();
                return true;
            }
            ConfigMessage.fromKey("no-skill-tree", new Object[0]).send(player);
            return false;
        }
        if (args.length == 1) {
            if (!MMOCore.plugin.configManager.enableSpecificSkillTreeGUI) {
                sender.sendMessage(ChatColor.RED + "Usage: /skilltrees <skilltree-id>");
                return false;
            }
            if (data.getProfess().getSkillTrees().stream().filter(skillTree -> UtilityMethods.ymlName((String)skillTree.getId()).equals(UtilityMethods.ymlName((String)args[0]))).collect(Collectors.toList()).size() != 0) {
                InventoryManager.SPECIFIC_TREE_VIEW.get(UtilityMethods.ymlName((String)args[0])).newInventory(data).open();
                return true;
            }
            sender.sendMessage(ChatColor.RED + "Your class does not have a skill tree with id: " + args[0]);
            return false;
        }
        if (MMOCore.plugin.configManager.enableSpecificSkillTreeGUI) {
            sender.sendMessage(ChatColor.RED + "Usage: /skilltrees <skilltree-id>");
        } else {
            sender.sendMessage(ChatColor.RED + "Usage: /skilltrees");
        }
        return false;
    }
}

