/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.command;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.command.api.RegisteredCommand;
import net.Indyuce.mmocore.command.api.ToggleableCommand;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PvpModeCommand
extends RegisteredCommand {
    public static final String COOLDOWN_KEY = "PvpMode";

    public PvpModeCommand(ConfigurationSection config) {
        super(config, ToggleableCommand.PVP_MODE);
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command is for players only.");
            return false;
        }
        if (!sender.hasPermission("mmocore.pvpmode")) {
            ConfigMessage.fromKey("not-enough-perms", new Object[0]).send((Player)sender);
            return false;
        }
        PlayerData playerData = PlayerData.get((OfflinePlayer)((Player)sender));
        if (playerData.getCooldownMap().isOnCooldown(COOLDOWN_KEY)) {
            ConfigMessage.fromKey("pvp-mode.cooldown", "remaining", MythicLib.plugin.getMMOConfig().decimal.format(playerData.getCooldownMap().getCooldown(COOLDOWN_KEY))).send((Player)sender);
            return true;
        }
        playerData.getCombat().setPvpMode(!playerData.getCombat().isInPvpMode());
        playerData.getCooldownMap().applyCooldown(COOLDOWN_KEY, playerData.getCombat().isInPvpMode() ? MMOCore.plugin.configManager.pvpModeToggleOnCooldown : MMOCore.plugin.configManager.pvpModeToggleOffCooldown);
        if (playerData.getCombat().isInPvpMode() && MythicLib.plugin.getFlags().isFlagAllowed(playerData.getPlayer(), CustomFlag.PVP_MODE)) {
            playerData.getCombat().setInvulnerable(MMOCore.plugin.configManager.pvpModeInvulnerabilityTimeCommand);
            ConfigMessage.fromKey("pvp-mode.toggle.on-invulnerable", "time", MythicLib.plugin.getMMOConfig().decimal.format(MMOCore.plugin.configManager.pvpModeInvulnerabilityTimeCommand)).send(playerData.getPlayer());
        } else {
            ConfigMessage.fromKey("pvp-mode.toggle." + (playerData.getCombat().isInPvpMode() ? "on" : "off") + "-safe", new Object[0]).send((Player)sender);
        }
        return true;
    }
}

