/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.api.quest.trigger;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.quest.trigger.Trigger;
import net.Indyuce.mmocore.api.util.math.formula.RandomAmount;
import net.Indyuce.mmocore.experience.EXPSource;
import net.Indyuce.mmocore.experience.SimpleExperienceObject;
import net.Indyuce.mmocore.experience.dispenser.ExperienceDispenser;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class ExperienceTrigger
extends Trigger {
    @NotNull
    private final RandomAmount amount;
    @NotNull
    private final EXPSource source;
    @NotNull
    private final ExperienceDispenser dispenser;

    public ExperienceTrigger(MMOLineConfig config) {
        super(config);
        config.validate(new String[]{"amount"});
        if (config.contains("profession")) {
            String id = config.getString("profession").toLowerCase().replace("_", "-");
            Validate.isTrue((boolean)MMOCore.plugin.professionManager.has(id), (String)"Could not find profession");
            this.dispenser = MMOCore.plugin.professionManager.get(id);
        } else {
            this.dispenser = new SimpleExperienceObject();
        }
        this.amount = new RandomAmount(config.getString("amount"));
        this.source = config.contains("source") ? EXPSource.valueOf(config.getString("source").toUpperCase()) : EXPSource.QUEST;
    }

    @Override
    public void apply(PlayerData player) {
        this.dispenser.giveExperience(player, this.amount.calculate(), null, this.source);
    }
}

