/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.InjectionRequest;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.guice.bean.binders.DependencyAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private final DependencyAnalyzer analyzer = new DependencyAnalyzer();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
    }

    public Set<Key<?>> getImportedKeys() {
        Set<Key<Key<?>>> keys = this.analyzer.getRequiredKeys();
        keys.removeAll(this.localKeys);
        return keys;
    }

    public <T> Void visit(Binding<T> binding) {
        if (this.localKeys.contains(binding.getKey())) {
            return null;
        }
        if (((Boolean)binding.acceptTargetVisitor((BindingTargetVisitor)this.analyzer)).booleanValue()) {
            this.localKeys.add(binding.getKey());
            binding.applyTo(this.binder);
        }
        return null;
    }

    public Void visit(InjectionRequest<?> request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

