/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.position;

import dev.aurelium.slate.inv.content.SlotPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroupUtil {
    private final int size;
    private final int startRow;
    private final int startCol;
    private final int endRow;
    private final int endCol;

    public GroupUtil(int size, int startRow, int startCol, int endRow, int endCol) {
        this.size = size;
        this.startRow = startRow;
        this.startCol = startCol;
        this.endRow = endRow;
        this.endCol = endCol;
    }

    public List<SlotPos> getCenterSlots() {
        ArrayList<SlotPos> result = new ArrayList<SlotPos>();
        int rows = this.endRow - this.startRow + 1;
        int cols = this.endCol - this.startCol + 1;
        int slotsPerRow = (int)Math.ceil((double)this.size / (double)rows);
        int offset = (cols - slotsPerRow) / 2;
        int count = 0;
        for (int i = this.startRow; i <= this.endRow; ++i) {
            for (int j = this.startCol + offset; j < this.startCol + offset + slotsPerRow && count < this.size; ++count, ++j) {
                result.add(SlotPos.of(i, j));
            }
        }
        return result;
    }

    public List<SlotPos> getLeftSlots() {
        ArrayList<SlotPos> result = new ArrayList<SlotPos>();
        int count = 0;
        for (int i = this.startRow; i <= this.endRow; ++i) {
            for (int j = this.startCol; j <= this.endCol && count < this.size; ++count, ++j) {
                result.add(SlotPos.of(i, j));
            }
        }
        return result;
    }

    public List<SlotPos> getRightSlots() {
        ArrayList<SlotPos> result = new ArrayList<SlotPos>();
        int count = 0;
        for (int i = this.endRow; i >= this.startRow; --i) {
            for (int j = this.endCol; j >= this.startCol && count < this.size; ++count, --j) {
                result.add(SlotPos.of(i, j));
            }
        }
        Collections.reverse(result);
        return result;
    }
}

