/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.lore.parser;

import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.lore.LoreStyles;
import dev.aurelium.slate.lore.parser.LoreParser;
import dev.aurelium.slate.lore.type.TextLore;
import java.util.HashMap;
import org.spongepowered.configurate.ConfigurationNode;

public class TextLoreParser
implements LoreParser {
    @Override
    public LoreLine parse(ConfigurationNode config) {
        if (!config.isMap()) {
            String text = config.getString("");
            return new TextLore(text, new LoreStyles(new HashMap<Integer, String>()), false, 0, false, "");
        }
        String text = config.node(new Object[]{"text"}).getString("");
        LoreStyles styles = this.parseStyles(config);
        boolean wrap = config.node(new Object[]{"wrap"}).getBoolean(false);
        int wrapStyle = config.node(new Object[]{"wrap_style"}).getInt(0);
        boolean smartWrap = config.node(new Object[]{"smart_wrap"}).getBoolean(true);
        String wrapIndent = config.node(new Object[]{"wrap_indent"}).getString("");
        return new TextLore(text, styles, wrap, wrapStyle, smartWrap, wrapIndent);
    }

    private LoreStyles parseStyles(ConfigurationNode config) {
        if (!config.node(new Object[]{"style"}).virtual()) {
            String style = config.node(new Object[]{"style"}).getString("");
            HashMap<Integer, String> styleMap = new HashMap<Integer, String>();
            styleMap.put(0, style);
            return new LoreStyles(styleMap);
        }
        if (config.node(new Object[]{"styles"}).isMap()) {
            HashMap<Integer, String> styleMap = new HashMap<Integer, String>();
            for (ConfigurationNode styleNode : config.node(new Object[]{"styles"}).childrenMap().values()) {
                int index;
                Object key = styleNode.key();
                if (key instanceof String) {
                    index = Integer.parseInt((String)key);
                } else {
                    if (!(key instanceof Integer)) continue;
                    index = (Integer)key;
                }
                String style = styleNode.getString();
                if (style == null) continue;
                styleMap.put(index, style);
            }
            return new LoreStyles(styleMap);
        }
        return new LoreStyles(new HashMap<Integer, String>());
    }
}

