/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.fill;

import dev.aurelium.slate.inv.content.SlotPos;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.configurate.ConfigurationNode;

public class SlotParser {
    public SlotPos[] parse(ConfigurationNode section, int size) {
        List slotList = (List)section.node(new Object[]{"slots"}).raw();
        if (slotList != null) {
            SlotPos[] slots = new SlotPos[slotList.size()];
            int index = 0;
            for (Object element : slotList) {
                String str;
                String[] splitStr;
                if (element instanceof Integer) {
                    int value = (Integer)element;
                    slots[index] = SlotPos.of(value / 9, value % 9);
                } else if (element instanceof String && (splitStr = (str = (String)element).split(",")).length > 1) {
                    slots[index] = SlotPos.of(Integer.parseInt(splitStr[0]), Integer.parseInt(splitStr[1]));
                }
                ++index;
            }
            return slots;
        }
        if (!section.node(new Object[]{"shape"}).virtual()) {
            String shape;
            switch (shape = section.node(new Object[]{"shape"}).getString("border")) {
                case "border": {
                    ArrayList<SlotPos> slots = new ArrayList<SlotPos>();
                    for (int i = 0; i < 9; ++i) {
                        slots.add(SlotPos.of(0, i));
                        slots.add(SlotPos.of(size - 1, i));
                    }
                    for (int r = 1; r < size - 1; ++r) {
                        slots.add(SlotPos.of(r, 0));
                        slots.add(SlotPos.of(r, 8));
                    }
                    return slots.toArray(new SlotPos[0]);
                }
                case "top_row": {
                    SlotPos[] slots = new SlotPos[9];
                    for (int i = 0; i < 9; ++i) {
                        slots[i] = SlotPos.of(0, i);
                    }
                    return slots;
                }
                case "bottom_row": {
                    SlotPos[] slots = new SlotPos[9];
                    for (int i = 0; i < 9; ++i) {
                        slots[i] = SlotPos.of(size - 1, i);
                    }
                    return slots;
                }
                case "left_column": {
                    SlotPos[] slots = new SlotPos[size];
                    for (int i = 0; i < size; ++i) {
                        slots[i] = SlotPos.of(i, 0);
                    }
                    return slots;
                }
                case "right_column": {
                    SlotPos[] slots = new SlotPos[size];
                    for (int i = 0; i < size; ++i) {
                        slots[i] = SlotPos.of(i, 8);
                    }
                    return slots;
                }
            }
        }
        return null;
    }
}

