/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version.wrapper;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTCompound;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.NBTTypeHelper;
import io.lumine.mythic.lib.util.lang3.NotImplementedException;
import io.lumine.mythic.lib.version.OreDrops;
import io.lumine.mythic.lib.version.VInventoryView;
import io.lumine.mythic.lib.version.wrapper.VersionWrapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.ChatMessageType;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerAccess;
import net.minecraft.server.v1_16_R3.ContainerAnvil;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ICrafting;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagString;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayInArmAnimation;
import net.minecraft.server.v1_16_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_16_R3.PacketPlayOutChat;
import net.minecraft.server.v1_16_R3.PacketPlayOutCloseWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.SoundEffectType;
import net.minecraft.server.v1_16_R3.TileEntitySkull;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.craftbukkit.libs.org.apache.commons.lang3.reflect.FieldUtils;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class VersionWrapper_1_16_R3
implements VersionWrapper {
    private final Set<Material> generatorOutputs = new HashSet<Material>();
    private static final OreDrops IRON_ORE = new OreDrops(Material.IRON_INGOT);
    private static final OreDrops GOLD_ORE = new OreDrops(Material.GOLD_INGOT);
    private static final OreDrops ANCIENT_DEBRIS = new OreDrops(Material.NETHERITE_SCRAP);

    public VersionWrapper_1_16_R3() {
        this.generatorOutputs.add(Material.COBBLESTONE);
        this.generatorOutputs.add(Material.OBSIDIAN);
        this.generatorOutputs.add(Material.BASALT);
    }

    @Override
    public String getBiomeName(Biome biome) {
        return biome.name();
    }

    @Override
    public String getSoundName(Sound sound) {
        return sound.name();
    }

    @Override
    public Object getProfile(SkullMeta meta) {
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            Object profile = profileField.get(meta);
            profileField.setAccessible(false);
            return profile;
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new IllegalArgumentException("Could not fetch skull profile:" + exception.getMessage());
        }
    }

    @Override
    public void setProfile(SkullMeta meta, Object object) {
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, object);
            profileField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new IllegalArgumentException("Could not apply skull profile:" + exception.getMessage());
        }
    }

    @Override
    public Object newProfile(UUID uniqueId, String textureValue) {
        GameProfile profile = new GameProfile(uniqueId, "SkullTexture");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", textureValue));
        return profile;
    }

    @Override
    public boolean isGeneratorOutput(Material material) {
        return this.generatorOutputs.contains(material);
    }

    @Override
    public boolean isHelmet(Material material) {
        return material.name().endsWith("HELMET") || material == Material.CARVED_PUMPKIN || material == Material.PLAYER_HEAD || material == Material.CREEPER_HEAD || material == Material.SKELETON_SKULL || material == Material.WITHER_SKELETON_SKULL;
    }

    @Override
    public OreDrops getOreDrops(Material material) {
        switch (material) {
            case IRON_ORE: {
                return IRON_ORE;
            }
            case GOLD_ORE: {
                return GOLD_ORE;
            }
            case ANCIENT_DEBRIS: {
                return ANCIENT_DEBRIS;
            }
        }
        return null;
    }

    @Override
    public float getAttackCooldown(Player player) {
        return player.getAttackCooldown();
    }

    @Override
    public int getFoodRestored(org.bukkit.inventory.ItemStack item) {
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item).getItem().getFoodInfo().getNutrition();
    }

    @Override
    public float getSaturationRestored(org.bukkit.inventory.ItemStack item) {
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item).getItem().getFoodInfo().getSaturationModifier();
    }

    @Override
    public void sendJson(Player player, String message) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)message), ChatMessageType.CHAT, UUID.randomUUID()));
    }

    @Override
    public void sendActionBarRaw(Player player, String message) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)message), ChatMessageType.GAME_INFO, UUID.randomUUID()));
    }

    @Override
    public int getNextContainerId(Player player) {
        return this.toNMS(player).nextContainerCounter();
    }

    @Override
    public void handleInventoryCloseEvent(Player player) {
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)this.toNMS(player));
    }

    @Override
    public void sendPacketOpenWindow(Player player, int containerId) {
        this.toNMS((Player)player).playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(containerId, Containers.ANVIL, (IChatBaseComponent)new ChatMessage("Repair & Name")));
    }

    @Override
    public void sendPacketCloseWindow(Player player, int containerId) {
        this.toNMS((Player)player).playerConnection.sendPacket((Packet)new PacketPlayOutCloseWindow(containerId));
    }

    @Override
    public void setActiveContainerDefault(Player player) {
        this.toNMS((Player)player).activeContainer = this.toNMS((Player)player).defaultContainer;
    }

    @Override
    public void setActiveContainer(Player player, Object container) {
        this.toNMS((Player)player).activeContainer = (Container)container;
    }

    @Override
    public void setActiveContainerId(Object container, int containerId) {
        Field field = null;
        try {
            field = Container.class.getField("windowId");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        FieldUtils.removeFinalModifier((Field)field);
        try {
            FieldUtils.writeField((Field)field, (Object)container, (Object)containerId);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addActiveContainerSlotListener(Object container, Player player) {
        ((Container)container).addSlotListener((ICrafting)this.toNMS(player));
    }

    @Override
    public Inventory toBukkitInventory(Object container) {
        return ((Container)container).getBukkitView().getTopInventory();
    }

    @Override
    public Object newContainerAnvil(Player player) {
        return new AnvilContainer(player);
    }

    private EntityPlayer toNMS(Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Override
    public NBTItem getNBTItem(org.bukkit.inventory.ItemStack item) {
        return new NBTItem_v1_16_R3(item);
    }

    @Override
    public void playArmAnimation(Player player) {
        EntityPlayer p = ((CraftPlayer)player).getHandle();
        PlayerConnection connection = p.playerConnection;
        PacketPlayOutAnimation armSwing = new PacketPlayOutAnimation((Entity)p, 0);
        connection.sendPacket((Packet)armSwing);
        connection.a(new PacketPlayInArmAnimation(EnumHand.MAIN_HAND));
    }

    @Override
    public Sound getBlockPlaceSound(Block block) {
        try {
            WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
            net.minecraft.server.v1_16_R3.Block nmsBlock = nmsWorld.getType(new BlockPosition(block.getX(), block.getY(), block.getZ())).getBlock();
            SoundEffectType soundEffectType = nmsBlock.getStepSound(nmsBlock.getBlockData());
            Field breakSound = SoundEffectType.class.getDeclaredField("Z");
            breakSound.setAccessible(true);
            SoundEffect nmsSound = (SoundEffect)breakSound.get(soundEffectType);
            Field keyField = SoundEffect.class.getDeclaredField("b");
            keyField.setAccessible(true);
            MinecraftKey nmsString = (MinecraftKey)keyField.get(nmsSound);
            return Sound.valueOf((String)nmsString.getKey().replace(".", "_").toUpperCase());
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSkullValue(Block block) {
        TileEntitySkull skullTile = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (skullTile.gameProfile == null) {
            return "";
        }
        return ((Property)skullTile.gameProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
    }

    @Override
    public void setSkullValue(Block block, String value) {
        TileEntitySkull skullTile = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        skullTile.setGameProfile(profile);
        skullTile.update();
    }

    @Override
    public FurnaceRecipe getFurnaceRecipe(String path, org.bukkit.inventory.ItemStack item, Material material, float exp, int cook) {
        return new FurnaceRecipe(new NamespacedKey((Plugin)MythicLib.inst(), "mmoitems_furnace_" + path), item, material, exp, cook);
    }

    @Override
    public Enchantment getEnchantmentFromString(String s) {
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)s));
    }

    @Override
    public FurnaceRecipe getFurnaceRecipe(NamespacedKey key, org.bukkit.inventory.ItemStack item, Material material, float exp, int cook) {
        return new FurnaceRecipe(key, item, material, exp, cook);
    }

    @Override
    public boolean isCropFullyGrown(Block block) {
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    @Override
    public boolean isUndead(org.bukkit.entity.Entity entity) {
        EntityType type = entity.getType();
        return type == EntityType.SKELETON || type == EntityType.STRAY || type == EntityType.WITHER_SKELETON || type == EntityType.ZOMBIE || type == EntityType.DROWNED || type == EntityType.HUSK || type.name().equals("PIG_ZOMBIE") || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.PHANTOM || type == EntityType.WITHER || type == EntityType.SKELETON_HORSE || type == EntityType.ZOMBIE_HORSE;
    }

    @Override
    public void setUUID(Player player, UUID uniqueId) {
        if (player.getUniqueId().equals(uniqueId)) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)player).getHandle();
        GameProfile gameProfile = handle.getProfile();
        try {
            Field _id = gameProfile.getClass().getDeclaredField("id");
            _id.setAccessible(true);
            _id.set(gameProfile, uniqueId);
            _id.setAccessible(false);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not update player UUID", exception);
        }
        handle.setUUID(uniqueId);
    }

    @Override
    public GameProfile getGameProfile(Player player) {
        return ((CraftPlayer)player).getProfile();
    }

    @Override
    public VInventoryView getView(InventoryEvent event) {
        return new InventoryViewImpl(event.getView());
    }

    @Override
    public VInventoryView getOpenInventory(Player player) {
        return new InventoryViewImpl(player.getOpenInventory());
    }

    @Override
    public InventoryClickEvent newInventoryClickEvent(VInventoryView view, InventoryType.SlotType type, int slot, ClickType click, InventoryAction action) {
        return new InventoryClickEvent(((InventoryViewImpl)view).view, type, slot, click, action);
    }

    private class AnvilContainer
    extends ContainerAnvil {
        public AnvilContainer(Player player) {
            super(VersionWrapper_1_16_R3.this.getNextContainerId(player), ((CraftPlayer)player).getHandle().inventory, ContainerAccess.at((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)new ChatMessage("Repair & Name"));
        }
    }

    public static class NBTItem_v1_16_R3
    extends NBTItem {
        private final ItemStack nms;
        private final NBTTagCompound compound;

        public NBTItem_v1_16_R3(org.bukkit.inventory.ItemStack item) {
            super(item);
            this.nms = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
            this.compound = this.nms.hasTag() ? this.nms.getTag() : new NBTTagCompound();
        }

        @Override
        public Object get(String path) {
            return this.compound.get(path);
        }

        @Override
        public String getString(String path) {
            return this.compound.getString(path);
        }

        @Override
        public boolean hasTag(String path) {
            return this.compound.hasKey(path);
        }

        @Override
        public boolean getBoolean(String path) {
            return this.compound.getBoolean(path);
        }

        @Override
        public double getDouble(String path) {
            return this.compound.getDouble(path);
        }

        @Override
        public int getInteger(String path) {
            return this.compound.getInt(path);
        }

        @Override
        public NBTCompound getNBTCompound(String path) {
            return new NBTCompound_v1_16_R3(this, path);
        }

        @Override
        public NBTItem addTag(List<ItemTag> tags) {
            tags.forEach(tag -> {
                if (tag.getValue() instanceof Boolean) {
                    this.compound.setBoolean(tag.getPath(), ((Boolean)tag.getValue()).booleanValue());
                } else if (tag.getValue() instanceof Double) {
                    this.compound.setDouble(tag.getPath(), ((Double)tag.getValue()).doubleValue());
                } else if (tag.getValue() instanceof String) {
                    this.compound.setString(tag.getPath(), (String)tag.getValue());
                } else if (tag.getValue() instanceof Integer) {
                    this.compound.setInt(tag.getPath(), ((Integer)tag.getValue()).intValue());
                } else if (tag.getValue() instanceof List) {
                    NBTTagList tagList = new NBTTagList();
                    for (Object s : (List)tag.getValue()) {
                        if (!(s instanceof String)) continue;
                        tagList.add((Object)NBTTagString.a((String)((String)s)));
                    }
                    this.compound.set(tag.getPath(), (NBTBase)tagList);
                }
            });
            return this;
        }

        @Override
        public NBTItem removeTag(String ... paths) {
            for (String path : paths) {
                this.compound.remove(path);
            }
            return this;
        }

        @Override
        public Set<String> getTags() {
            return this.compound.getKeys();
        }

        @Override
        public org.bukkit.inventory.ItemStack toItem() {
            this.nms.setTag(this.compound);
            return CraftItemStack.asBukkitCopy((ItemStack)this.nms);
        }

        @Override
        public int getTypeId(String path) {
            return this.compound.get(path).getTypeId();
        }

        @Override
        public void setCanMine(Collection<Material> blocks) {
            throw new NotImplementedException("Not supported in <1.21");
        }
    }

    private static class InventoryViewImpl
    implements VInventoryView {
        private final InventoryView view;

        InventoryViewImpl(InventoryView view) {
            this.view = view;
        }

        @Override
        public String getTitle() {
            return this.view.getTitle();
        }

        @Override
        public InventoryType getType() {
            return this.view.getType();
        }

        @Override
        public Inventory getTopInventory() {
            return this.view.getTopInventory();
        }

        @Override
        public Inventory getBottomInventory() {
            return this.view.getBottomInventory();
        }

        @Override
        public void setCursor(org.bukkit.inventory.ItemStack actualCursor) {
            this.view.setCursor(actualCursor);
        }

        @Override
        public HumanEntity getPlayer() {
            return this.view.getPlayer();
        }

        @Override
        public void close() {
            this.view.close();
        }
    }

    private static class NBTCompound_v1_16_R3
    extends NBTCompound {
        private final NBTTagCompound compound;

        public NBTCompound_v1_16_R3(NBTItem_v1_16_R3 item, String path) {
            this.compound = item.hasTag(path) && NBTTypeHelper.COMPOUND.is(item.getTypeId(path)) ? item.compound.getCompound(path) : new NBTTagCompound();
        }

        public NBTCompound_v1_16_R3(NBTCompound_v1_16_R3 comp, String path) {
            this.compound = comp.hasTag(path) && NBTTypeHelper.COMPOUND.is(comp.getTypeId(path)) ? comp.compound.getCompound(path) : new NBTTagCompound();
        }

        @Override
        public boolean hasTag(String path) {
            return this.compound.hasKey(path);
        }

        @Override
        public Object get(String path) {
            return this.compound.get(path);
        }

        @Override
        public NBTCompound getNBTCompound(String path) {
            return new NBTCompound_v1_16_R3(this, path);
        }

        @Override
        public String getString(String path) {
            return this.compound.getString(path);
        }

        @Override
        public boolean getBoolean(String path) {
            return this.compound.getBoolean(path);
        }

        @Override
        public double getDouble(String path) {
            return this.compound.getDouble(path);
        }

        @Override
        public int getInteger(String path) {
            return this.compound.getInt(path);
        }

        @Override
        public Set<String> getTags() {
            return this.compound.getKeys();
        }

        @Override
        public int getTypeId(String path) {
            return this.compound.get(path).getTypeId();
        }
    }
}

