/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.version.Attributes;
import io.lumine.mythic.lib.version.VInventoryView;
import io.lumine.mythic.lib.version.wrapper.VersionWrapper;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionUtils {
    private static final NamespacedKey NSK_TRICK = new NamespacedKey((Plugin)MythicLib.plugin, "attr_mod_decoy");
    private static final Attribute NSK_ATTRIBUTE = Attributes.FOLLOW_RANGE;

    @NotNull
    public static AttributeModifier attrMod(@NotNull NamespacedKey key, double amount, @NotNull AttributeModifier.Operation operation) {
        return VersionWrapper.get().newAttributeModifier(key, amount, operation);
    }

    @NotNull
    public static AttributeModifier emptyAttributeModifier() {
        return VersionWrapper.get().newAttributeModifier(NSK_TRICK, 0.0, AttributeModifier.Operation.ADD_NUMBER);
    }

    @Nullable
    public static AttributeModifier getModifier(AttributeInstance instance, NamespacedKey key) {
        for (AttributeModifier modifier : instance.getModifiers()) {
            if (!modifier.getKey().equals((Object)key)) continue;
            return modifier;
        }
        return null;
    }

    @NotNull
    public static void addEmptyAttributeModifier(@NotNull ItemMeta meta) {
        meta.addAttributeModifier(NSK_ATTRIBUTE, VersionUtils.emptyAttributeModifier());
    }

    public static boolean matches(@NotNull AttributeModifier modifier, @NotNull NamespacedKey key) {
        return VersionWrapper.get().matches(modifier, key);
    }

    @NotNull
    public static VInventoryView getView(@NotNull InventoryEvent event) {
        return VersionWrapper.get().getView(event);
    }

    @NotNull
    public static String name(@NotNull Biome biome) {
        return VersionWrapper.get().getBiomeName(biome);
    }

    @NotNull
    public static String name(@NotNull Sound sound) {
        return VersionWrapper.get().getSoundName(sound);
    }

    @NotNull
    public static VInventoryView getOpen(@NotNull Player player) {
        return VersionWrapper.get().getOpenInventory(player);
    }

    @NotNull
    public static InventoryClickEvent invClickEvent(@NotNull VInventoryView view, @NotNull InventoryType.SlotType type, int slot, @NotNull ClickType click, @NotNull InventoryAction action) {
        return VersionWrapper.get().newInventoryClickEvent(view, type, slot, click, action);
    }
}

