/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VEnchantment;
import io.lumine.mythic.lib.version.VEntityType;
import io.lumine.mythic.lib.version.VMaterial;
import io.lumine.mythic.lib.version.VParticle;
import io.lumine.mythic.lib.version.VPotionEffectType;
import io.lumine.mythic.lib.version.wrapper.VersionWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ServerVersion {
    private final String craftBukkitVersion;
    private final int revNumber;
    private final int[] bukkitVersion;
    private final VersionWrapper versionWrapper;
    private final boolean paper;
    private static final int MAXIMUM_INDEX = 3;
    private static final int MAXIMUM_REVISION_NUMBER = 10;
    private static final String CLASS_NAME_USED = "CraftServer";

    @Deprecated
    public ServerVersion(Class<?> ignored) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this();
    }

    public ServerVersion() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        VersionWrapper found;
        String[] bukkitSplit = Bukkit.getServer().getBukkitVersion().split("\\-")[0].split("\\.");
        this.bukkitVersion = new int[Math.min(3, bukkitSplit.length)];
        for (int i = 0; i < this.bukkitVersion.length; ++i) {
            this.bukkitVersion[i] = Integer.parseInt(bukkitSplit[i]);
        }
        this.revNumber = this.findRevisionNumber();
        this.craftBukkitVersion = this.craftBukkitVersion(this.revNumber);
        try {
            found = (VersionWrapper)Class.forName("io.lumine.mythic.lib.version.wrapper.VersionWrapper_" + this.craftBukkitVersion.substring(1)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            MythicLib.plugin.getLogger().log(Level.WARNING, "Non-natively supported Spigot version detected, trying reflection-based compatibility mode");
            found = (VersionWrapper)Class.forName("io.lumine.mythic.lib.version.wrapper.VersionWrapper_Reflection").getDeclaredConstructor(ServerVersion.class).newInstance(this);
        }
        this.versionWrapper = found;
        boolean isPaper = false;
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            isPaper = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.paper = isPaper;
        try {
            VEnchantment.values();
            VEntityType.values();
            VMaterial.values();
            VParticle.values();
            VPotionEffectType.values();
            Validate.notNull(Sounds.ENTITY_ENDERMAN_HURT, "Error with sounds", new Object[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Compatibility error: " + throwable.getMessage());
        }
    }

    @NotNull
    private String craftBukkitVersion(int revNumber) {
        return "v" + this.bukkitVersion[0] + "_" + this.bukkitVersion[1] + "_R" + revNumber;
    }

    private int findRevisionNumber() {
        try {
            Class bukkitServerClass = Bukkit.getServer().getClass();
            String rev = bukkitServerClass.getPackage().getName().replace(".", ",").split(",")[3];
            return Integer.parseInt(rev.split("_")[2].replaceAll("[^0-9]", ""));
        }
        catch (Throwable bukkitServerClass) {
            for (int revNumber = 1; revNumber < 10; ++revNumber) {
                try {
                    String candidate = this.craftBukkitVersion(revNumber);
                    Class.forName("org.bukkit.craftbukkit." + candidate + "." + CLASS_NAME_USED);
                    return revNumber;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            return 0;
        }
    }

    public boolean isPaper() {
        return this.paper;
    }

    public boolean isAbove(int ... version) {
        Validate.isTrue(version.length >= 1 && version.length <= 3, "Provide at least 1 integer and at most 3", new Object[0]);
        int maxLength = Math.min(3, Math.max(version.length, this.bukkitVersion.length));
        for (int i = 0; i < maxLength; ++i) {
            int provided;
            int server = i >= this.bukkitVersion.length ? 0 : this.bukkitVersion[i];
            int n = provided = i >= version.length ? 0 : version[i];
            if (server == provided) continue;
            return server > provided;
        }
        return true;
    }

    public boolean isUnder(int ... version) {
        return !this.isAbove(version);
    }

    @NotNull
    public String getCraftBukkitVersion() {
        return this.craftBukkitVersion;
    }

    public int getRevisionNumber() {
        return this.revNumber;
    }

    public int[] getBukkitVersion() {
        return this.bukkitVersion;
    }

    @NotNull
    public VersionWrapper getWrapper() {
        return this.versionWrapper;
    }

    public String toString() {
        return "ServerVersion{revision='" + this.craftBukkitVersion + '\'' + ", revisionNumber=" + this.revNumber + ", integers=" + Arrays.toString(this.bukkitVersion) + ", paper=" + this.paper + '}';
    }

    @Deprecated
    public String getRevision() {
        return this.getCraftBukkitVersion();
    }

    @Deprecated
    public int[] toNumbers() {
        return this.bukkitVersion;
    }

    @Deprecated
    public int[] getIntegers() {
        return this.getBukkitVersion();
    }

    @Deprecated
    public boolean isStrictlyHigher(int ... version) {
        Validate.isTrue(version.length >= 1 && version.length <= 3, "Provide at least 1 integer and at most 3", new Object[0]);
        int maxLength = Math.min(3, Math.max(version.length, this.bukkitVersion.length));
        for (int i = 0; i < maxLength; ++i) {
            int provided;
            int server = i >= this.bukkitVersion.length ? 0 : this.bukkitVersion[i];
            int n = provided = i >= version.length ? 0 : version[i];
            if (server == provided) continue;
            return server > provided;
        }
        return false;
    }

    @Deprecated
    public boolean isBelowOrEqual(int ... version) {
        return !this.isStrictlyHigher(version);
    }
}

