/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OreDrops {
    private final Material material;
    private final int min;
    private final int max;
    private static final Random RANDOM = new Random();

    public OreDrops(Material material) {
        this(material, 1, 1);
    }

    public OreDrops(Material material, int min, int max) {
        Validate.notNull(material, "Material cannot be null", new Object[0]);
        Validate.isTrue(min > 0, "Min amount must be positive", new Object[0]);
        Validate.isTrue(max >= min, "Max amount must be higher than min amount", new Object[0]);
        this.material = material;
        this.min = min;
        this.max = max;
    }

    @NotNull
    public ItemStack generate(int fortuneLevel) {
        Validate.isTrue(fortuneLevel >= 0, "Fortune level must be positive", new Object[0]);
        int rolled = this.min == this.max ? this.min : RANDOM.nextInt(this.min, this.max + 1);
        return new ItemStack(this.material, rolled * this.rollFortuneCoefficient(fortuneLevel));
    }

    private int rollFortuneCoefficient(int fortuneLevel) {
        if (fortuneLevel == 0) {
            return 1;
        }
        if (RANDOM.nextDouble() < 2.0 / (2.0 + (double)fortuneLevel)) {
            return 1;
        }
        return RANDOM.nextInt(2, fortuneLevel + 2);
    }
}

