/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.network;

import io.lumine.mythic.lib.util.network.LightInjector;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicPacketSniffer
extends LightInjector {
    private static final double MAX_RANGE = 5.0;
    private static final Map<String, Map<String, Field>> FIELDS = new ConcurrentHashMap<String, Map<String, Field>>();

    public MythicPacketSniffer(@NotNull Plugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Object onPacketReceiveAsync(@Nullable Player sender, @NotNull Channel channel, @NotNull Object packet) {
        if (sender == null) {
            return packet;
        }
        String packetName = packet.getClass().getSimpleName();
        if (packetName.equals("PacketPlayInArmAnimation")) {
            Object hand = this.getField(packet, "a");
            if (hand == null || !hand.toString().equals("MAIN_HAND")) {
                return packet;
            }
            Bukkit.getScheduler().runTask(this.getPlugin(), () -> {
                SeenEntity entity = this.getLineOfSight(sender);
                if (entity != null) {
                    this.triggerEvent(sender);
                }
            });
        }
        return packet;
    }

    @Override
    @Nullable
    protected Object onPacketSendAsync(@Nullable Player receiver, @NotNull Channel channel, @NotNull Object packet) {
        return packet;
    }

    @Nullable
    private SeenEntity getLineOfSight(Player player) {
        RayTraceResult result = player.getWorld().rayTrace(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0, FluidCollisionMode.NEVER, true, 0.0, entity -> entity instanceof LivingEntity && !entity.equals((Object)player));
        if (result == null) {
            return null;
        }
        Entity entity2 = result.getHitEntity();
        if (entity2 == null || entity2 instanceof Player && ((Player)entity2).getGameMode().ordinal() == 3) {
            return null;
        }
        double distance = result.getHitPosition().distance(player.getEyeLocation().toVector());
        return new SeenEntity(entity2, distance);
    }

    private void triggerEvent(@NotNull Player player) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerInteractEvent(player, Action.LEFT_CLICK_AIR, player.getInventory().getItemInMainHand(), null, BlockFace.EAST, EquipmentSlot.HAND));
    }

    @Nullable
    private Object getField(Object object, String field) {
        return this.getField(object, object.getClass(), field);
    }

    @Nullable
    private Object getField(Object object, Class<?> c, String field) {
        Map<Object, Object> map;
        Field f;
        Map<String, Field> fs;
        if (FIELDS.containsKey(c.getCanonicalName()) && (fs = FIELDS.get(c.getCanonicalName())).containsKey(field)) {
            try {
                return fs.get(field).get(object);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
        Class<?> current = c;
        while (true) {
            try {
                f = current.getDeclaredField(field);
            }
            catch (ReflectiveOperationException e1) {
                current = current.getSuperclass();
                if (current != null) continue;
                return null;
            }
            break;
        }
        f.setAccessible(true);
        if (FIELDS.containsKey(c.getCanonicalName())) {
            map = FIELDS.get(c.getCanonicalName());
        } else {
            map = new ConcurrentHashMap();
            FIELDS.put(c.getCanonicalName(), map);
        }
        map.put(f.getName(), f);
        try {
            return f.get(object);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private class SeenEntity {
        @NotNull
        final Entity entity;
        final double distance;

        private SeenEntity(Entity entity, double distance) {
            this.entity = entity;
            this.distance = distance;
        }
    }
}

