/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.lang3;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class Validate {
    private static final String DEFAULT_NOT_NAN_EX_MESSAGE = "The validated value is not a number";
    private static final String DEFAULT_FINITE_EX_MESSAGE = "The value is invalid: %f";
    private static final String DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified exclusive range of %s to %s";
    private static final String DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified inclusive range of %s to %s";
    private static final String DEFAULT_MATCHES_PATTERN_EX = "The string %s does not match the pattern %s";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
    private static final String DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE = "The validated collection contains null element at index: %d";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE = "The validated array index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE = "The validated collection index is invalid: %d";
    private static final String DEFAULT_VALID_STATE_EX_MESSAGE = "The validated state is false";
    private static final String DEFAULT_IS_ASSIGNABLE_EX_MESSAGE = "Cannot assign a %s to a %s";
    private static final String DEFAULT_IS_INSTANCE_OF_EX_MESSAGE = "Expected type: %s, actual: %s";
    private static final String StringUtils_EMPTY = "";

    public static void exclusiveBetween(double start, double end, double value) {
        if (value <= start || value >= end) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static void exclusiveBetween(double start, double end, double value, String message) {
        if (value <= start || value >= end) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void exclusiveBetween(long start, long end, long value) {
        if (value <= start || value >= end) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static void exclusiveBetween(long start, long end, long value, String message) {
        if (value <= start || value >= end) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void exclusiveBetween(T start, T end, Comparable<T> value) {
        if (value.compareTo(start) <= 0 || value.compareTo(end) >= 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static <T> void exclusiveBetween(T start, T end, Comparable<T> value, String message, Object ... values) {
        if (value.compareTo(start) <= 0 || value.compareTo(end) >= 0) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static void finite(double value) {
        Validate.finite(value, DEFAULT_FINITE_EX_MESSAGE, value);
    }

    public static void finite(double value, String message, Object ... values) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    private static String getMessage(String message, Object ... values) {
        return Validate.ArrayUtils__isEmpty(values) ? message : String.format(message, values);
    }

    private static boolean ArrayUtils__isEmpty(Object[] array) {
        return Validate.ArrayUtils__isArrayEmpty(array);
    }

    private static boolean ArrayUtils__isArrayEmpty(Object array) {
        return Array.getLength(array) == 0;
    }

    public static void inclusiveBetween(double start, double end, double value) {
        if (value < start || value > end) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static void inclusiveBetween(double start, double end, double value, String message) {
        if (value < start || value > end) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void inclusiveBetween(long start, long end, long value) {
        if (value < start || value > end) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static void inclusiveBetween(long start, long end, long value, String message) {
        if (value < start || value > end) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void inclusiveBetween(T start, T end, Comparable<T> value) {
        if (value.compareTo(start) < 0 || value.compareTo(end) > 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value, start, end));
        }
    }

    public static <T> void inclusiveBetween(T start, T end, Comparable<T> value, String message, Object ... values) {
        if (value.compareTo(start) < 0 || value.compareTo(end) > 0) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type) {
        if (type == null || superType == null || !superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_ASSIGNABLE_EX_MESSAGE, Validate.ClassUtils_getName(type, "null type"), Validate.ClassUtils_getName(superType, "null type")));
        }
    }

    private static String ClassUtils_getName(Class<?> cls) {
        return Validate.ClassUtils_getName(cls, StringUtils_EMPTY);
    }

    public static String ClassUtils_getName(Class<?> cls, String valueIfNull) {
        return cls == null ? valueIfNull : cls.getName();
    }

    public static String ClassUtils_getName(Object object) {
        return Validate.ClassUtils_getName(object, StringUtils_EMPTY);
    }

    public static String ClassUtils_getName(Object object, String valueIfNull) {
        return object == null ? valueIfNull : object.getClass().getName();
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type, String message, Object ... values) {
        if (!superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_INSTANCE_OF_EX_MESSAGE, type.getName(), Validate.ClassUtils_getName(obj, "null")));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message, Object ... values) {
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static void isTrue(boolean expression, String message, double value) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, value));
        }
    }

    public static void isTrue(boolean expression, String message, long value) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, value));
        }
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(String.format(DEFAULT_MATCHES_PATTERN_EX, input, pattern));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern, String message, Object ... values) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable) {
        return Validate.noNullElements(iterable, DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message, Object ... values) {
        Objects.requireNonNull(iterable, "iterable");
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                Object[] values2 = Validate.ArrayUtils__addAll(values, i);
                throw new IllegalArgumentException(Validate.getMessage(message, values2));
            }
            ++i;
        }
        return iterable;
    }

    public static <T> T[] noNullElements(T[] array) {
        return Validate.noNullElements(array, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array, String message, Object ... values) {
        Objects.requireNonNull(array, "array");
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            Object[] values2 = Validate.ArrayUtils_add(values, i);
            throw new IllegalArgumentException(Validate.getMessage(message, values2));
        }
        return array;
    }

    private static <T> T[] ArrayUtils_add(T[] array, T element) {
        Class<?> type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] newArray = (Object[])Validate.ArrayUtils__copyArrayGrow1(array, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static <T> T[] ArrayUtils__addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return Validate.ArraysUtils__clone(array2);
        }
        if (array2 == null) {
            return Validate.ArraysUtils__clone(array1);
        }
        Class type1 = Validate.ArraysUtils__getComponentType(array1);
        Object[] joinedArray = Validate.ArrayUtils__arraycopy(array1, 0, 0, array1.length, () -> Validate.ArrayUtils__newInstance(type1, array1.length + array2.length));
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static <T> T[] ArrayUtils__newInstance(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    private static <T> Class<T> ArraysUtils__getComponentType(T[] array) {
        return Validate.ClassUtils__getComponentType(Validate.ObjectUtils__getClass(array));
    }

    private static <T> Class<T> ClassUtils__getComponentType(Class<T[]> cls) {
        return cls == null ? null : cls.getComponentType();
    }

    private static <T> Class<T> ObjectUtils__getClass(T object) {
        return object == null ? null : object.getClass();
    }

    private static <T> T[] ArraysUtils__clone(T[] array) {
        return array != null ? (Object[])array.clone() : null;
    }

    private static <T> T ArrayUtils__arraycopy(T source, int sourcePos, int destPos, int length, Function<Integer, T> allocator) {
        return Validate.ArrayUtils__arraycopy(source, sourcePos, allocator.apply(length), destPos, length);
    }

    private static <T> T ArrayUtils__arraycopy(T source, int sourcePos, int destPos, int length, Supplier<T> allocator) {
        return Validate.ArrayUtils__arraycopy(source, sourcePos, allocator.get(), destPos, length);
    }

    private static <T> T ArrayUtils__arraycopy(T source, int sourcePos, T dest, int destPos, int length) {
        System.arraycopy(source, sourcePos, dest, destPos, length);
        return dest;
    }

    private static Object ArrayUtils__copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public static <T extends CharSequence> T notBlank(T chars) {
        return Validate.notBlank(chars, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T chars, String message, Object ... values) {
        Objects.requireNonNull(chars, Validate.toSupplier(message, values));
        if (Validate.StringUtils__isBlank(chars)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
        return chars;
    }

    private static boolean StringUtils__isBlank(CharSequence cs) {
        int strLen = Validate.StringUtils__length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int StringUtils__length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        return Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Map<?, ?>> T notEmpty(T map) {
        return Validate.notEmpty(map, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T chars) {
        return Validate.notEmpty(chars, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message, Object ... values) {
        Objects.requireNonNull(collection, Validate.toSupplier(message, values));
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map, String message, Object ... values) {
        Objects.requireNonNull(map, Validate.toSupplier(message, values));
        if (map.isEmpty()) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
        return map;
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message, Object ... values) {
        Objects.requireNonNull(chars, Validate.toSupplier(message, values));
        if (chars.length() == 0) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
        return chars;
    }

    public static <T> T[] notEmpty(T[] array) {
        return Validate.notEmpty(array, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] notEmpty(T[] array, String message, Object ... values) {
        Objects.requireNonNull(array, Validate.toSupplier(message, values));
        if (array.length == 0) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
        return array;
    }

    public static void notNaN(double value) {
        Validate.notNaN(value, DEFAULT_NOT_NAN_EX_MESSAGE, new Object[0]);
    }

    public static void notNaN(double value, String message, Object ... values) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(Validate.getMessage(message, values));
        }
    }

    @Deprecated
    public static <T> T notNull(T object) {
        return Validate.notNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    public static <T> T notNull(T object, String message, Object ... values) {
        return Objects.requireNonNull(object, Validate.toSupplier(message, values));
    }

    private static Supplier<String> toSupplier(String message, Object ... values) {
        return () -> Validate.getMessage(message, values);
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index) {
        return Validate.validIndex(collection, index, DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE, new Object[]{index});
    }

    public static <T extends CharSequence> T validIndex(T chars, int index) {
        return Validate.validIndex(chars, index, DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE, index);
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index, String message, Object ... values) {
        Objects.requireNonNull(collection, "collection");
        if (index < 0 || index >= collection.size()) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message, values));
        }
        return collection;
    }

    public static <T extends CharSequence> T validIndex(T chars, int index, String message, Object ... values) {
        Objects.requireNonNull(chars, "chars");
        if (index < 0 || index >= chars.length()) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message, values));
        }
        return chars;
    }

    public static <T> T[] validIndex(T[] array, int index) {
        return Validate.validIndex(array, index, DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE, index);
    }

    public static <T> T[] validIndex(T[] array, int index, String message, Object ... values) {
        Objects.requireNonNull(array, "array");
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message, values));
        }
        return array;
    }

    public static void validState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException(DEFAULT_VALID_STATE_EX_MESSAGE);
        }
    }

    public static void validState(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalStateException(Validate.getMessage(message, values));
        }
    }
}

