/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.gson;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.gson.JsonDeserializationContext;
import io.lumine.mythic.lib.gson.JsonDeserializer;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParseException;
import io.lumine.mythic.lib.gson.JsonSerializationContext;
import io.lumine.mythic.lib.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;

public class AttributeModifierAdapter
implements JsonSerializer<AttributeModifier>,
JsonDeserializer<AttributeModifier> {
    @Override
    public AttributeModifier deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        EquipmentSlotGroup group;
        NamespacedKey key;
        JsonObject object = element.getAsJsonObject();
        if (object.has("Name")) {
            key = this.convertToNamespacedKey(object.get("UUID").getAsString(), object.get("Name").getAsString());
            group = object.has("Slot") ? EquipmentSlot.valueOf((String)object.get("Slot").getAsString()).getGroup() : EquipmentSlotGroup.ANY;
        } else {
            key = NamespacedKey.fromString((String)object.get("Key").getAsString());
            group = Objects.requireNonNullElse(EquipmentSlotGroup.getByName((String)object.get("Group").getAsString()), EquipmentSlotGroup.ANY);
        }
        return new AttributeModifier(key, object.get("Amount").getAsDouble(), AttributeModifier.Operation.valueOf((String)object.get("Operation").getAsString()), group);
    }

    private NamespacedKey convertToNamespacedKey(String uuid, String name) {
        if (name.startsWith("mythiclib.") || name.startsWith("mmoitems.") || name.startsWith("mmolib.")) {
            return new NamespacedKey((Plugin)MythicLib.plugin, name.split("\\.", 2)[1]);
        }
        return new NamespacedKey((Plugin)MythicLib.plugin, uuid);
    }

    @Override
    public JsonElement serialize(AttributeModifier modifier, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject object = new JsonObject();
        object.addProperty("Key", modifier.getKey().toString());
        object.addProperty("Amount", modifier.getAmount());
        object.addProperty("Operation", modifier.getOperation().name());
        object.addProperty("Group", modifier.getSlotGroup().toString());
        return object;
    }
}

