/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.configobject;

import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonPrimitive;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonWrapper
implements ConfigObject {
    protected final String key;
    protected final JsonObject object;

    public JsonWrapper(String key, JsonObject object) {
        this.key = key;
        this.object = object;
    }

    protected JsonWrapper(String value) {
        if (!value.contains("{") || !value.contains("}")) {
            this.object = new JsonObject();
            this.key = null;
            return;
        }
        int begin = value.indexOf("{");
        int end = value.lastIndexOf("}") + 1;
        this.object = JsonParser.parseString(value.substring(begin, end)).getAsJsonObject();
        this.key = this.nullify(value.substring(0, begin));
    }

    @Nullable
    private String nullify(@Nullable String str) {
        return str == null || str.isEmpty() ? null : str;
    }

    @Override
    public String getString(String key) {
        return this.object.get(key).getAsString();
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.object.has(key) ? this.getString(key) : defaultValue;
    }

    @Override
    public double getDouble(String key) {
        return this.object.get(key).getAsDouble();
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.object.has(key) ? this.getDouble(key) : defaultValue;
    }

    @Override
    public int getInt(String key) {
        return this.object.get(key).getAsInt();
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.object.has(key) ? this.getInt(key) : defaultValue;
    }

    @Override
    @NotNull
    public ConfigObject adaptObject(String key) {
        JsonObject loadFrom;
        JsonElement found = this.object.get(key);
        if (found instanceof JsonObject) {
            loadFrom = found.getAsJsonObject();
        } else if (found instanceof JsonPrimitive) {
            loadFrom = new JsonObject();
            loadFrom.addProperty("type", found.getAsString());
        } else {
            throw new IllegalArgumentException("Expecting either a string or object");
        }
        return new JsonWrapper(key, loadFrom);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.object.get(key).getAsBoolean();
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.object.has(key) ? this.getBoolean(key) : defaultValue;
    }

    @Override
    @NotNull
    public ConfigObject getObject(String key) {
        return new JsonWrapper(key, this.object.getAsJsonObject(key));
    }

    @Override
    public boolean contains(String key) {
        return this.object.has(key);
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return this.object.keySet();
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

