/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;
import org.jetbrains.annotations.NotNull;

public class Tasks {
    private static final List<Integer> ASYNC_SAFE_TASKS = new ArrayList<Integer>();
    private static final List<Integer> SYNC_SAFE_TASKS = new ArrayList<Integer>();
    private static final long ASYNC_TIME_OUT = 50L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSafeAsync(@NotNull BukkitTask task) {
        List<Integer> list = ASYNC_SAFE_TASKS;
        synchronized (list) {
            return ASYNC_SAFE_TASKS.contains(task.getTaskId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSafeSync(@NotNull BukkitTask task) {
        List<Integer> list = SYNC_SAFE_TASKS;
        synchronized (list) {
            return SYNC_SAFE_TASKS.contains(task.getTaskId());
        }
    }

    public static boolean isSafe(@NotNull BukkitTask task) {
        return Tasks.isSafeSync(task) || Tasks.isSafeAsync(task);
    }

    public static void executePendingSafe(@NotNull Plugin plugin) {
        for (BukkitTask pending : Bukkit.getScheduler().getPendingTasks()) {
            if (!pending.getOwner().equals((Object)plugin) || !Tasks.isSafe(pending)) continue;
            ((Runnable)pending).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitSafe(@NotNull Plugin plugin) {
        for (BukkitWorker worker : Bukkit.getScheduler().getActiveWorkers()) {
            if (!worker.getOwner().equals((Object)plugin)) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CompletableFuture<Void> runSafeAsync(@NotNull Plugin plugin, @NotNull Runnable runnable) {
        CompletableFuture future = new CompletableFuture();
        BukkitTask task = Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Tasks.printStackTraceSync(plugin, throwable);
            }
            future.complete(null);
        });
        List<Integer> list = ASYNC_SAFE_TASKS;
        synchronized (list) {
            ASYNC_SAFE_TASKS.add(task.getTaskId());
        }
        return future.thenRun(() -> {
            List<Integer> list = ASYNC_SAFE_TASKS;
            synchronized (list) {
                ASYNC_SAFE_TASKS.remove((Object)task.getTaskId());
            }
        });
    }

    private static void printStackTraceSync(@NotNull Plugin plugin, @NotNull Throwable throwable) {
        Bukkit.getScheduler().runTask(plugin, () -> {
            plugin.getLogger().log(Level.INFO, "Caught error on async thread:");
            throwable.printStackTrace();
        });
    }

    @NotNull
    public static CompletableFuture<Void> runAsync(@NotNull Plugin plugin, @NotNull Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously(plugin, task -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Tasks.printStackTraceSync(plugin, throwable);
            }
            future.complete(null);
        });
        return future;
    }

    public static <T> Consumer<T> sync(@NotNull Plugin plugin, @NotNull Consumer<T> syncTask) {
        return t -> Bukkit.getScheduler().runTask(plugin, () -> syncTask.accept(t));
    }
}

