/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.result.def;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.util.RayTrace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class TargetSkillResult
implements SkillResult {
    private final LivingEntity target;

    public TargetSkillResult(SkillMetadata skillMeta) {
        this(skillMeta, InteractionType.OFFENSE_SKILL);
    }

    public TargetSkillResult(SkillMetadata skillMeta, InteractionType interactType) {
        this(skillMeta, 50.0, interactType);
    }

    public TargetSkillResult(SkillMetadata skillMeta, double range, InteractionType interactType) {
        Player caster = skillMeta.getCaster().getPlayer();
        this.target = skillMeta.hasTargetEntity() && MythicLib.plugin.getEntities().canInteract(caster, skillMeta.getTargetEntityOrNull(), interactType) ? (LivingEntity)skillMeta.getTargetEntityOrNull() : new RayTrace(caster, range, entity -> MythicLib.plugin.getEntities().canInteract(caster, (Entity)entity, interactType)).getHit();
    }

    public TargetSkillResult(@Nullable LivingEntity target) {
        this.target = target;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public boolean isSuccessful() {
        return this.target != null;
    }
}

