/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Holy_Missile
extends SkillHandler<VectorSkillResult> {
    public Holy_Missile() {
        this.registerModifiers("damage", "duration");
    }

    @Override
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        final double duration = skillMeta.getParameter("duration") * 10.0;
        final double damage = skillMeta.getParameter("damage");
        caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_FIREWORK_ROCKET_BLAST, 1.0f, 1.0f);
        new BukkitRunnable(){
            final Vector vec;
            final Location loc;
            double ti;
            {
                this.vec = result.getTarget().multiply(0.45);
                this.loc = caster.getLocation().clone().add(0.0, 1.3, 0.0);
                this.ti = 0.0;
            }

            public void run() {
                double d = this.ti;
                this.ti = d + 1.0;
                if (d > duration) {
                    this.cancel();
                }
                this.loc.getWorld().playSound(this.loc, Sounds.BLOCK_NOTE_BLOCK_HAT, 2.0f, 1.0f);
                List<Entity> entities = UtilityMethods.getNearbyChunkEntities(this.loc);
                for (int j = 0; j < 2; ++j) {
                    this.loc.add(this.vec);
                    if (this.loc.getBlock().getType().isSolid()) {
                        this.cancel();
                    }
                    for (double i = -Math.PI; i < Math.PI; i += 1.5707963267948966) {
                        Vector v = new Vector(Math.cos(i + this.ti / 4.0), Math.sin(i + this.ti / 4.0), 0.0);
                        v = UtilityMethods.rotate(v, this.loc.getDirection());
                        this.loc.getWorld().spawnParticle(VParticle.FIREWORK.get(), this.loc, 0, v.getX(), v.getY(), v.getZ(), 0.08);
                    }
                    for (Entity entity : entities) {
                        if (!UtilityMethods.canTarget(caster, this.loc, entity)) continue;
                        this.loc.getWorld().spawnParticle(VParticle.LARGE_EXPLOSION.get(), this.loc, 1);
                        this.loc.getWorld().spawnParticle(VParticle.FIREWORK.get(), this.loc, 32, 0.0, 0.0, 0.0, 0.2);
                        this.loc.getWorld().playSound(this.loc, Sounds.ENTITY_GENERIC_EXPLODE, 2.0f, 1.0f);
                        skillMeta.getCaster().attack((LivingEntity)entity, damage, DamageType.SKILL, DamageType.MAGIC, DamageType.PROJECTILE);
                        this.cancel();
                        return;
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

