/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Cursed_Beam
extends SkillHandler<VectorSkillResult> {
    public Cursed_Beam() {
        this.registerModifiers("damage", "duration");
    }

    @Override
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        final double duration = skillMeta.getParameter("duration");
        caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_WITHER_SHOOT, 2.0f, 2.0f);
        new BukkitRunnable(){
            final Vector dir;
            final Location loc;
            final double r = 0.4;
            int ti;
            {
                this.dir = result.getTarget().multiply(0.3);
                this.loc = caster.getEyeLocation().clone();
                this.r = 0.4;
                this.ti = 0;
            }

            public void run() {
                ++this.ti;
                if (this.ti > 50) {
                    this.cancel();
                }
                List<Entity> entities = UtilityMethods.getNearbyChunkEntities(this.loc);
                for (double j = 0.0; j < 4.0; j += 1.0) {
                    this.loc.add(this.dir);
                    for (double i = 0.0; i < Math.PI * 2; i += 0.5235987755982988) {
                        Vector vec = UtilityMethods.rotate(new Vector(0.4 * Math.cos(i), 0.4 * Math.sin(i), 0.0), this.loc.getDirection());
                        this.loc.add(vec);
                        this.loc.getWorld().spawnParticle(VParticle.WITCH.get(), this.loc, 0);
                        this.loc.add(vec.multiply(-1));
                    }
                    for (Entity target : entities) {
                        if (!UtilityMethods.canTarget(caster, this.loc, target)) continue;
                        Cursed_Beam.this.effect(target);
                        double damage = skillMeta.getParameter("damage");
                        this.loc.getWorld().playSound(this.loc, Sounds.ENTITY_ENDERMAN_TELEPORT, 2.0f, 0.7f);
                        for (Entity entity : entities) {
                            if (!UtilityMethods.canTarget(caster, entity) || !(this.loc.distanceSquared(entity.getLocation().add(0.0, 1.0, 0.0)) < 9.0)) continue;
                            skillMeta.getCaster().attack((LivingEntity)entity, damage, DamageType.SKILL, DamageType.MAGIC, DamageType.PROJECTILE);
                            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (int)(duration * 20.0), 0));
                        }
                        this.cancel();
                        return;
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    private void effect(final Entity ent) {
        new BukkitRunnable(){
            final Location loc2;
            double y;
            {
                this.loc2 = ent.getLocation();
                this.y = 0.0;
            }

            public void run() {
                for (int i = 0; i < 3; ++i) {
                    this.y += 0.05;
                    for (int j = 0; j < 2; ++j) {
                        double xz = this.y * Math.PI * 0.8 + (double)j * Math.PI;
                        this.loc2.getWorld().spawnParticle(VParticle.WITCH.get(), this.loc2.clone().add(Math.cos(xz) * 2.5, this.y, Math.sin(xz) * 2.5), 0);
                    }
                }
                if (this.y >= 3.0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

